(define-datatype expression expression?
  (lit-exp
   (value scheme-value?))
  (var-exp
   (id symbol?))
  (lambda-exp
   (ids (list-of symbol?))
   (body expression?))
  (if-exp
   (conditional expression?)
   (if-true expression?)
   (if-false expression?))
  (app-exp
   (exps (list-of expression?))))

(define scheme-value? (lambda (v) #t))

(define parse-expression
  (lambda (datum)
    (cond [(symbol? datum) (var-exp datum)]
	  [(number? datum) (lit-exp datum)]
	  [(boolean? datum) (lit-exp datum)]
	  [(pair? datum)
	   (cond [(eqv? (car datum) 'lambda)
		  (lambda-exp (cadr datum)
			      (parse-expression (caddr datum)))]
		 [(eqv? (car datum) 'if)
		  (if-exp (parse-expression (cadr datum))
			  (parse-expression (caddr datum))
			  (parse-expression (cadddr  datum)))]
		 [else (app-exp (map parse-expression datum))])]
	  [else (eopl:error 'parse-expression
			    "Invalid concrete syntax ~s" datum)])))


