(define-datatype environment environment?
  [empty-env-record]
  [extended-env-record
   (syms (list-of symbol?))
   (vals (list-of scheme-value?))
   (env environment?)])

(define scheme-value? (lambda (v) #t))

(define empty-env
  (lambda ()
    (empty-env-record)))

(define extend-env
  (lambda (syms vals env)
    (extended-env-record syms vals env)))

(define apply-env
  (lambda (env sym)
    (cases environment env
	   [empty-env-record ()
			     (eopl:error 'apply-env "No binding for ~s" sym)]
	   [extended-env-record (syms vals env)
				(let ((pos (find-position sym syms 0)))
				  (if (number? pos)
				      (list-ref vals pos)
				      (apply-env env sym)))])))

(define find-position
  (lambda (sym ls pos)
    (cond [(null? ls) #f]
	  [(eq? sym (car ls)) pos]
	  [else (find-position sym (cdr ls) (+ pos 1))])))



(define init-env
  (lambda ()
    (extend-env '(add1 - list)
		(list (lambda (x) (+ x 1)) (lambda (l) (apply - l)) (lambda (l) (apply list l)))
		(empty-env))))
