/*
    Copyright (c) 1996-1997 Swiss Federal Institute of Technology, 
    Computer Engineering and Networks Laboratory. All rights reserved.

    MIPS Simulator for a R3000 based machine. For details, have a look at the
    hardware documentation of the Integrated Device Technology ID79R3052E 
    processor and the evaluation board 7RS385.
    
    Permission to use, copy, modify, and distribute this software and its
    documentation for any purpose, without fee, and without written 
    agreement is hereby granted, provided that the above copyright notice 
    and the following two paragraphs appear in all copies of this software.

    IN NO EVENT SHALL THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER 
    ENGINEERING AND NETWORKS LABORATORY BE LIABLE TO ANY PARTY FOR
    DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING 
    OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
    THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER ENGINEERING AND 
    NETWORKS LABORATORY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

    THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER ENGINEERING AND 
    NETWORKS LABORATORY, SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, 
    BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND 
    FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS 
    ON AN "AS IS" BASIS, AND THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, 
    COMPUTER ENGINEERING AND NETWORKS LABORATORY HAS NO OBLIGATION TO 
    PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

    
    File:                  $Source: /private/proj/topsy/gfa/MipsSimulator/RCS/SimulatorApplet.java,v $
    Author(s):             George Fankhauser
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 98/04/13 16:41:34 $      by: $Author: gfa $
    
    
    $Log:	SimulatorApplet.java,v $
Revision 1.1  98/04/13  16:41:34  gfa
Initial revision

*/


import java.applet.*;
import java.awt.*;
import java.lang.*;
import java.net.*;
import java.io.*;
import Simulator;
import AppletStream;


public class SimulatorApplet extends Applet {

    String param, options[] = {"-b", "topsy.srec"};
    TextField textfield;
    TextArea textarea;
    Simulator sim;
    
    public static final int BUFLEN = 1000;
    public static AppletStream out;
    public static char inputBuffer[] = new char[BUFLEN];
    public static int inp = 0, outp = 0;

    public void init() {
    
        showStatus("Loading Mips R3000 Simulator");

	makeTextArea(this);

	SimulatorApplet.out = new AppletStream(textarea);
    
    }
    
    
    public void start() {

    	URL url = null;
	InputStream input;
	DataInputStream kernelStream = null;
		
	param = getParameter("kernel");
	
	try {
	    url = new URL(getDocumentBase(), param);
	    kernelStream = new DataInputStream(url.openStream());
	}
	catch (Exception e) {
	    System.out.println("couldn't open kernel:" + url.toString());
	}
	this.show();
	this.repaint();

        sim = new Simulator();
	sim.main(options, kernelStream);

    }

    int makeTextArea(Panel w) {

	w.setLayout(new FlowLayout());

	textarea = new TextArea(24, 80);
	textarea.setEditable(false);
	textarea.setBackground(Color.white);
	textarea.setFont(new Font("Courier", Font.PLAIN, 10));

	w.add("Center", textarea);

	textfield = new TextField(80);
	textfield.setFont(new Font("Courier", Font.PLAIN, 10));
	w.add("South", textfield);

	w.resize(518, 378);
	w.show();

	textfield.requestFocus();
	w.repaint();
        return 0;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case Event.ACTION_EVENT:
                if (event.target == textfield) {
                    String input = (String)event.arg + '\n';
					out.print(input);
		    input.getChars(0, input.length(), inputBuffer, inp);
		    inp = (inp + input.length()) % BUFLEN;
                    textfield.setText("");
                    return true;
                }
        }
        return false;
    }

    public String getAppletInfo() {
        return "Mips R3000 Simulator, (c) 1996-1997 George Fankhauser, " + 
							    "gfa@acm.org";
    }
}


