/*
	Copyright (c) 1996-1997 Swiss Federal Institute of Technology, 
	Computer Engineering and Networks Laboratory. All rights reserved.

	MIPS Simulator for a R3000 based machine. For details, have a look at the
	hardware documentation of the Integrated Device Technology ID79R3052E 
	processor and the evaluation board 7RS385.
	
	Permission to use, copy, modify, and distribute this software and its
	documentation for any purpose, without fee, and without written 
	agreement is hereby granted, provided that the above copyright notice 
	and the following two paragraphs appear in all copies of this software.

	IN NO EVENT SHALL THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER 
	ENGINEERING AND NETWORKS LABORATORY BE LIABLE TO ANY PARTY FOR
	DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING 
	OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
	THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER ENGINEERING AND 
	NETWORKS LABORATORY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

	THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER ENGINEERING AND 
	NETWORKS LABORATORY, SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, 
	BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND 
	FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS 
	ON AN "AS IS" BASIS, AND THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, 
	COMPUTER ENGINEERING AND NETWORKS LABORATORY HAS NO OBLIGATION TO 
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /private/proj/topsy/gfa/MipsSimulator/RCS/Simulator.version_for_applet.java,v $
 	Author(s):             G. Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.1 $
 	Creation Date:         December 1996
 	Last Date of Change:   $Date: 98/04/13 16:56:37 $      by: $Author: gfa $
	
	
	$Log:	Simulator.version_for_applet.java,v $
Revision 1.1  98/04/13  16:56:37  gfa
Initial revision

# Revision 1.2  1997/04/06  12:59:41  gfa
# adapted for the applet interface, processor runs also as a thread...
#
# Revision 1.1  1997/02/04  10:42:01  topsy
# Initial revision
#
*/

import java.lang.*;
import java.io.*;
import SimulatorApplet;
import AppletStream;
import Processor;
import KernelLoader;
import KernelLoaderException;

public final class Simulator extends Object
{	
	static Processor proc;
	public static boolean traceMode = false;
	public static boolean verboseMode = false;
	public static boolean bigEndian = false;
	
	public static void main(String argv[], DataInputStream is)
	{
		String bootFilename = "topsy";	// default kernel name
		RandomAccessFile kernelFile;

		// print some nice message and open kernel file
		SimulatorApplet.out.print("\nMIPS/IDT R3052E Simulator - (c) 1996-1997 gfa\n");
		for (int i = 0; i < argv.length; i++) {
			if (argv[i].charAt(0) == '-') {
				if (argv[i].charAt(1) == 't') traceMode = true;
				else if (argv[i].charAt(1) == 'v') verboseMode = true;
				else if (argv[i].charAt(1) == 'b') bigEndian = true;
			}
			else {
				bootFilename = argv[i];
			}
		}
		SimulatorApplet.out.print("Configured as ");
		SimulatorApplet.out.print(bigEndian ? "big endian" : "little endian");
		SimulatorApplet.out.println(", trace="+traceMode+", verbose="+verboseMode);

		// now we have a stream with the kernel file, 
		// let's init cpu/memory/devices and load it
		try { 
			proc = new Processor();
		}
		catch (Exception exception) {
			SimulatorApplet.out.print("Couldn't create processor (");
			SimulatorApplet.out.print(exception.getClass().getName() + ")\n\n");
			return;
		}
		SimulatorApplet.out.print("Loading from '" + bootFilename + "'\n");
		try {
			new KernelLoader(null, proc.memory, proc, is);
		}
		catch (Exception exception) {
			SimulatorApplet.out.print("Couldn't load kernel (");
			SimulatorApplet.out.print(exception.getClass().getName() + ")\n\n");
			return;
		}
		// machine initialized, kernel loaded, let's go!		
		SimulatorApplet.out.print("ok. Booting from '"+ bootFilename +"'\n\n");
		try {
			new Thread(proc).start();
			//proc.run();
		}
		catch (Exception exception) {
			SimulatorApplet.out.print("Exception while running (");
			SimulatorApplet.out.print(exception.getClass().getName() + ")\n");
			proc.where();
			return;
		}
	}	
}
