/*
	Copyright (c) 1996-1997 Swiss Federal Institute of Technology, 
	Computer Engineering and Networks Laboratory. All rights reserved.

	MIPS Simulator for a R3000 based machine. For details, have a look at the
	hardware documentation of the Integrated Device Technology ID79R3052E 
	processor and the evaluation board 7RS385.
	
	Permission to use, copy, modify, and distribute this software and its
	documentation for any purpose, without fee, and without written 
	agreement is hereby granted, provided that the above copyright notice 
	and the following two paragraphs appear in all copies of this software.

	IN NO EVENT SHALL THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER 
	ENGINEERING AND NETWORKS LABORATORY BE LIABLE TO ANY PARTY FOR
	DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING 
	OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
	THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER ENGINEERING AND 
	NETWORKS LABORATORY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

	THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER ENGINEERING AND 
	NETWORKS LABORATORY, SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, 
	BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND 
	FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS 
	ON AN "AS IS" BASIS, AND THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, 
	COMPUTER ENGINEERING AND NETWORKS LABORATORY HAS NO OBLIGATION TO 
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /private/proj/topsy/gfa/MipsSimulator/RCS/FPGA_NetworkDevice.java,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.1 $
 	Creation Date:         
 	Last Date of Change:   $Date: 97/07/14 07:40:00 $      by: $Author: gfa $
	
	
	$Log:	FPGA_NetworkDevice.java,v $
# Revision 1.1  97/07/14  07:40:00  gfa
# Initial revision
# 
*/


import MemoryRegion;

public class FPGA_NetworkDevice extends MemoryRegion {

	final int FPGAADDRSIZE = 0xc0010;

	public FPGA_NetworkDevice(int baseAddress) {
	    from = baseAddress; 
	    to = baseAddress+FPGAADDRSIZE;
	}

	public byte readByte(int address) {
	    return (byte)0xff;
	}
	public int readInt(int address) {
	    return (int)0xffffffff;
	}
	public void writeByte(int address, byte data) {
	}
	public void writeInt(int address, int data) {
	}
}

