/*
    Copyright (c) 1996-1997 Swiss Federal Institute of Technology, 
    Computer Engineering and Networks Laboratory. All rights reserved.

    MIPS Simulator for a R3000 based machine. For details, have a look at the
    hardware documentation of the Integrated Device Technology ID79R3052E 
    processor and the evaluation board 7RS385.
    
    Permission to use, copy, modify, and distribute this software and its
    documentation for any purpose, without fee, and without written 
    agreement is hereby granted, provided that the above copyright notice 
    and the following two paragraphs appear in all copies of this software.

    IN NO EVENT SHALL THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER 
    ENGINEERING AND NETWORKS LABORATORY BE LIABLE TO ANY PARTY FOR
    DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING 
    OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
    THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER ENGINEERING AND 
    NETWORKS LABORATORY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

    THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, COMPUTER ENGINEERING AND 
    NETWORKS LABORATORY, SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, 
    BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND 
    FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS 
    ON AN "AS IS" BASIS, AND THE SWISS FEDERAL INSTITUTE OF TECHNOLOGY, 
    COMPUTER ENGINEERING AND NETWORKS LABORATORY HAS NO OBLIGATION TO 
    PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

    
    File:                  $Source: /private/proj/topsy/gfa/MipsSimulator/RCS/AppletStream.java,v $
    Author(s):             George Fankhauser
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 98/04/13 16:41:40 $      by: $Author: gfa $
    
    
    $Log:	AppletStream.java,v $
Revision 1.1  98/04/13  16:41:40  gfa
Initial revision

*/
import java.io.PrintStream;
import java.awt.*;

public class AppletStream extends PrintStream {

    TextArea textarea;
    
    public AppletStream(TextArea t) {
	super(System.out);
	textarea = t;
    }
    
    public void write(int b) {
	if (b != 13) textarea.appendText((char)b + "");
    }
    
    public void print(String s) {
	textarea.appendText(s);
    }
    
    public void println(String s) {
	textarea.appendText(s);
	textarea.appendText("\n");
    }
    
    public void flush() {
    }
    
    public int available() {
	if (SimulatorApplet.inp != SimulatorApplet.outp) return 1;
	else return 0;
    }
    
    public char read() {
        char c = SimulatorApplet.inputBuffer[SimulatorApplet.outp];
	SimulatorApplet.outp=(SimulatorApplet.outp+1) % SimulatorApplet.BUFLEN;
	return c;
    }
}

