<?php

#<gradebook>
#	<student id="1421" section="BD" />
#	<student id="1454" section="CB" />
#	<student id="1471" section="CB" />
#	...	
#	...
#	<student id="1781" section="BA"/>
#</gradebook>
#
#students.washington.edu/schoe101/grades/grades.php?student="1421"
#
#<student id="1421" section="BD">
#	<homework max="105" actual="93">15 13 13 13 10 15 14</homework>
#	<participation max="6" actual="6">1 1 1 1 1 1</participation>
#	<midterm max="100" actual="92">44 48</midterm>
#	<final max="80" actual="69">69</final>
#</student>
#

$INPUT_FILE = "grades.txt";

function idCheck($str) 
{
	return preg_match("/[0-9]{4}/", $str);
}

function totalPoints($work)
{
	$split_work = explode(" ", $work);
	$actual = 0;
	for ($i = 0; $i < count($split_work); $i++)
	{
		$actual += $split_work[$i];
	}
	
	return $actual;
}
# main program
if (!isset($_SERVER["REQUEST_METHOD"]) || $_SERVER["REQUEST_METHOD"] != "GET") 
{
	header("HTTP/1.1 400 Invalid Request");
	die("ERROR 400: Invalid request - This service accepts only GET requests.");
}

$student = "";

if (isset($_REQUEST["student"])) 
{
	if (idCheck($_REQUEST["student"]))
		$student = $_REQUEST["student"];
	else
	{
		header("HTTP/1.1 400 Invalid Request");
		die("ERROR 400: Invalid request - This service accepts only 4 digit student IDs.");
	}
}

# read file
if (!file_exists($INPUT_FILE)) 
{
	header("HTTP/1.1 500 Server Error");
	die("ERROR 500: Server error - Unable to read input file: $INPUT_FILE");
}
$lines = file($INPUT_FILE);

if ($student) 
{
	$found = false;
	
	for ($i = 0; $i < count($lines) && !$found; $i++) 
	{
		$cur_line = trim($lines[$i]);
		$split_line = explode("|", $cur_line);
		$cur_student = $split_line[0];
		
		if ($cur_student == $student) 
		{
			$section = $split_line[1];
			$homework = $split_line[2];
			$total_hmwk = totalPoints($homework);
			
			$participation = $split_line[3];
			$total_part = totalPoints($participation);
			
			$midterm = $split_line[4];
			$total_midterm = totalPoints($midterm);
			
			$final = $split_line[5];
			
			# found the student the user is searching for; print it as XML
			header("Content-type: application/xml");
			print "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
			print "<student id=\"$cur_student\" section=\"$section\">\n";
			print "\t<homework max=\"105\" actual=\"$total_hmwk\">$homework</homework>\n";
			print "\t<participation max=\"6\" actual=\"$total_part\">$participation</participation>\n";
			print "\t<midterm max=\"100\" actual=\"$total_midterm\">$midterm</midterm>\n";
			print "\t<final max=\"80\" actual=\"$final\">$final</final>\n";
			print "</student>\n";
			$found = true;
		}
	}
	
	if (!$found) 
	{
		header("HTTP/1.1 404 File Not Found");
		die("ERROR 404: The name \"$student\" was not found.");
	}
} 
else 
{
	header("Content-type: application/xml");
	print "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
	print "<gradebook>\n";
	for ($i = 0; $i < count($lines); $i++) 
	{
		$cur_line = trim($lines[$i]);
		$split_line = explode("|", $cur_line);
		$cur_student = $split_line[0];
		$section = $split_line[1];
		
		print "\t<student id=\"$cur_student\" section=\"$section\" />\n";
	}
	print "</gradebook>\n";
}
?>