/*
P1. Insert the students into the selection list.
P2. Insert their grades into the table (calculate GPA - bonus?).
X3. Show class statistics for individual assignments/tests.
X4. Draw a bell curve diagram based on the class data for individual assignments/tests.
X5? Extend the diagram to support data within specific sections.
*/
window.onload = function() 
{
	new Ajax.Request(
		"grades.php",
		{
			method: "GET",
			onSuccess: ajaxSuccess
		}
	);
};

function ajaxSuccess(ajax)
{
	var student = ajax.responseXML.getElementsByTagName("student");
	for (var i = 0; i < student.length; i++)
	{
		var option = document.createElement("option");
		option.ondblclick = getGrades;
		option.innerHTML = student[i].getAttribute("id");
		$("studentlist").appendChild(option);
	}
}

function getGrades()
{
	new Ajax.Request(
		"grades.php",
		{
			method: "GET",
			parameters: {student: this.innerHTML},
			onSuccess: showScores
		}
	);
}

function showScores(ajax)
{
	var studentNode = ajax.responseXML.getElementsByTagName("student")[0];
	$("student_id").textContent = studentNode.getAttribute("id");
	$("section").textContent = studentNode.getAttribute("section");;
	
	var hmwkNode = studentNode.getElementsByTagName("homework")[0];
	var hmwk = hmwkNode.firstChild.nodeValue;
	var split_hmwk = hmwk.split(" ");
	
	for (var i = 0; i < split_hmwk.length; i++)
	{
		var hmwkTD = "hmwk" + (i + 1);
		$(hmwkTD).textContent = split_hmwk[i];
	}
	
	var partNode = studentNode.getElementsByTagName("participation")[0];
	$("part").textContent = partNode.getAttribute("actual");
	
	var midtermNode = studentNode.getElementsByTagName("midterm")[0];
	var midterm = midtermNode.firstChild.nodeValue;
	var split_midterm = midterm.split(" ");
	
	for (var i = 0; i < split_midterm.length; i++)
	{
		var midtermTD = "midterm" + (i + 1);
		$(midtermTD).textContent = split_midterm[i];
	}
	
	var finalsNode = studentNode.getElementsByTagName("final")[0];
	$("final").textContent = finalsNode.firstChild.nodeValue;	
}
