var roster;
var cur_player;

window.onload = function() 
{
	new Ajax.Request(
		"bowling.php",
		{
			method: "GET",
			onSuccess: ajaxSuccess
		}
	);
};

function ajaxSuccess(ajax)
{
	var bowler = ajax.responseXML.getElementsByTagName("bowler");
	var player = "";
	roster = [];
	for (var i = 0; i < bowler.length; i++)
	{
		var name = bowler[i].getAttribute("name");
		roster[i] = name;
		var th = document.createElement("th");
		th.innerHTML = name;
		th.id = name;
		th.setAttribute("rowspan", "2");
		th.onclick = getStats;
		player = "player" + (i + 1);
		$(player).appendChild(th);
	}
}

function getStats()
{
	cur_player = this.innerHTML;
	new Ajax.Request(
		"bowling.php",
		{
			method: "GET",
			parameters: {bowler: this.innerHTML},
			onSuccess: showScores
		}
	);
}

function showScores(ajax)
{
	var bowlerNode = ajax.responseXML.getElementsByTagName("bowler")[0];
	var playerNode = bowlerNode.getAttribute("name");
	var count = 0;
	while ((cur_player != roster[count]) && (count < roster.length))
	{
		count++;
	}
	var stats = bowlerNode.firstChild.nodeValue;
	
	var score = stats.split("|");
	var player = "player" + (count + 1);
	var scores = "scores" + (count + 1); 
	var calculate = 0;
	
	for (var i = 0; i < score.length; i++)
	{
		var split_pins = score[i].split(" ");
		calculate += parseInt(split_pins[0]) + parseInt(split_pins[1]);
		
		var td1 = document.createElement("td");
		td1.innerHTML = calculate;
		$(scores).appendChild(td1);
		
		var td2 = document.createElement("td");
		td2.innerHTML = score[i];
		$(player).appendChild(td2);
	}
}