/*
P1. Insert the players into the scoreboard.
P2. Insert their scores into the scoreboard.
X3. Insert their total scores for each round into the scoreboard.
*/
var roster;
var cur_player;

window.onload = function() 
{
	new Ajax.Request(
		"bowling.php",
		{
			method: "GET",
			onSuccess: ajaxSuccess
		}
	);
};

function ajaxSuccess(ajax)
{
	var bowler = ajax.responseXML.getElementsByTagName("bowler");
	var player = "";
	roster = [];
	for (var i = 0; i < bowler.length; i++)
	{
		var name = bowler[i].getAttribute("name");
		roster[i] = name;
		var th = document.createElement("th");
		th.innerHTML = name;
		th.onclick = getStats;
		player = "player" + (i + 1);
		$(player).appendChild(th);
	}
}

function getStats()
{
	cur_player = this.innerHTML;
	new Ajax.Request(
		"bowling.php",
		{
			method: "GET",
			parameters: {bowler: this.innerHTML},
			onSuccess: showScores
		}
	);
}

function showScores(ajax)
{
	var bowlerNode = ajax.responseXML.getElementsByTagName("bowler")[0];
	var playerNode = bowlerNode.getAttribute("name");
	var count = 0;
	while ((cur_player != roster[count]) && (count < roster.length))
	{
		count++;
	}
	var scores = bowlerNode.firstChild.nodeValue;
	
	var score = scores.split("|");
	var player2 = "player" + (count + 1);
	for (var i = 0; i < score.length; i++)
	{
		var td = document.createElement("td");
		td.innerHTML = score[i];
		$(player2).appendChild(td);
	}
}