<?php
#<bowling>
#	<bowler name="Danny" />
#	<bowler name="Tim" />
#	<bowler name="Jim" />
#</bowling>
#
#<bowler name="Danny">
#	35 70 3S 03 33 X 9S 8S 62 9S6
#</bowler>
#

$INPUT_FILE = "bowling.txt";

# Removes all characters except letters/numbers from query parameters
function filter_chars($str) 
{
	return preg_replace("/[^A-Za-z0-9_]*/", "", $str);
}

# main program
if (!isset($_SERVER["REQUEST_METHOD"]) || $_SERVER["REQUEST_METHOD"] != "GET") 
{
	header("HTTP/1.1 400 Invalid Request");
	die("ERROR 400: Invalid request - This service accepts only GET requests.");
}

$bowler = "";

if (isset($_REQUEST["bowler"])) 
{
	$bowler = filter_chars($_REQUEST["bowler"]);
}

# read file
if (!file_exists($INPUT_FILE)) 
{
	header("HTTP/1.1 500 Server Error");
	die("ERROR 500: Server error - Unable to read input file: $INPUT_FILE");
}
$lines = file($INPUT_FILE);

if ($bowler) 
{
	$found = false;
	
	for ($i = 0; $i < count($lines) && !$found; $i += 2) 
	{
		$this_bowler = trim($lines[$i]);
		$this_score = trim($lines[$i + 1]);

		if ($this_bowler == $bowler) 
		{
			# found the bowler the user is searching for; print it as XML
			header("Content-type: application/xml");
			print "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
			print "<bowler name=\"$this_bowler\">\n";
			print "\t$this_score\n";
			print "</bowler>\n";
			$found = TRUE;
		}
	}
	
	if (!$found) 
	{
		header("HTTP/1.1 404 File Not Found");
		die("ERROR 404: The name \"$bowler\" was not found.");
	}
} 
else 
{
	header("Content-type: application/xml");
	print "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
	print "<bowling>\n";
	for ($i = 0; $i < count($lines); $i += 2) 
	{
		$this_bowler = trim($lines[$i]);
		print "\t<bowler name=\"$this_bowler\" />\n";
	}
	print "</bowling>\n";
}
?>