<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
	"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Confucius Say</title>
		<link href="proverbs.css" type="text/css" rel="stylesheet" />
	</head>

	<body>
		<h1>Confucius Say...</h1>
		
		<div>
			<?php
				for ($i = 0; $i < 40; $i++) {
					if ($i > 0 && $i % 10 == 0) {
						?>
						<br />
						<?php
					}
					?>
					<img src="chinky.jpg" alt="asian face" />
					<?php
				}
			?>
		</div>
		
		<p>
			Welcome to Confucius Proverbs page!  Each time you visit this page, a random wise proverb will be shown.  Enjoy.
		</p>
		
		<blockquote>
			<p>
				<?= read_random_proverb() ?>
			</p>
		</blockquote>
		
		<hr />
		
		<p>
			This page has been accessed <?= hit_counter() ?> times.
		</p>
	</body>
</html>

<?php
	$HIT_COUNTER_FILENAME = "hits.txt";

	# reads a random proverb file from disk and returns its text
	function read_random_proverb() {
		$all_proverbs = scandir("proverbs");
		$index = rand(0, count($all_proverbs) - 3) + 2;
		$filename = $all_proverbs[$index];
		$lines = file("proverbs/$filename");
		$proverb = implode("<br />\n", $lines);
		
		# make first letter be in a special style
		return "<span class=\"first\">{$proverb[0]}</span>" . substr($proverb, 1);
	}
	
	function hit_counter() {
		global $HIT_COUNTER_FILENAME;
		if (file_exists($HIT_COUNTER_FILENAME)) {
			$hits = (int) file_get_contents($HIT_COUNTER_FILENAME);
		} else {
			$hits = 0;
		}
		$hits++;
		file_put_contents($HIT_COUNTER_FILENAME, $hits);
		return $hits;
	}
?>
