module my_add_or_sub( input [3:0] a, 
					input [3:0] b,
					input op,
					output reg [3:0] r);
					
wire [3:0] adder_wire, subber_wire;
					
my_add the_adder(a, b, adder_wire);
my_sub the_subber(a, b, subber_wire);
					
always @ (*) begin
	case (op)
		1'b0 : r <= adder_wire;
		1'b1 : r <= subber_wire;
	endcase
end

endmodule
