/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.BinaryNode;
import weiss.nonstandard.DuplicateItemException;
import weiss.nonstandard.ItemNotFoundException;
import weiss.nonstandard.Rotations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplayTree<AnyType extends Comparable<? super AnyType>> {
    private BinaryNode<AnyType> newNode = null;
    private BinaryNode<AnyType> header = new BinaryNode<Object>(null);
    private BinaryNode<AnyType> root;
    private BinaryNode<AnyType> nullNode = new BinaryNode<Object>(null);

    public SplayTree() {
        this.nullNode.right = this.nullNode;
        this.nullNode.left = this.nullNode.right;
        this.root = this.nullNode;
    }

    public void insert(AnyType x) {
        if (this.newNode == null) {
            this.newNode = new BinaryNode<Object>(null);
        }
        this.newNode.element = x;
        if (this.root == this.nullNode) {
            this.newNode.right = this.nullNode;
            this.newNode.left = this.newNode.right;
            this.root = this.newNode;
        } else {
            this.root = this.splay(x, this.root);
            if (x.compareTo(this.root.element) < 0) {
                this.newNode.left = this.root.left;
                this.newNode.right = this.root;
                this.root.left = this.nullNode;
                this.root = this.newNode;
            } else if (x.compareTo(this.root.element) > 0) {
                this.newNode.right = this.root.right;
                this.newNode.left = this.root;
                this.root.right = this.nullNode;
                this.root = this.newNode;
            } else {
                throw new DuplicateItemException(x.toString());
            }
        }
        this.newNode = null;
    }

    public void remove(AnyType x) {
        BinaryNode newTree;
        this.root = this.splay(x, this.root);
        if (((Comparable)this.root.element).compareTo(x) != 0) {
            throw new ItemNotFoundException(x.toString());
        }
        if (this.root.left == this.nullNode) {
            newTree = this.root.right;
        } else {
            newTree = this.root.left;
            newTree = this.splay(x, newTree);
            newTree.right = this.root.right;
        }
        this.root = newTree;
    }

    public AnyType findMin() {
        if (this.isEmpty()) {
            return null;
        }
        BinaryNode<AnyType> ptr = this.root;
        while (ptr.left != this.nullNode) {
            ptr = ptr.left;
        }
        this.root = this.splay((Comparable)ptr.element, this.root);
        return (AnyType)((Comparable)ptr.element);
    }

    public AnyType findMax() {
        if (this.isEmpty()) {
            return null;
        }
        BinaryNode<AnyType> ptr = this.root;
        while (ptr.right != this.nullNode) {
            ptr = ptr.right;
        }
        this.root = this.splay((Comparable)ptr.element, this.root);
        return (AnyType)((Comparable)ptr.element);
    }

    public AnyType find(AnyType x) {
        this.root = this.splay(x, this.root);
        if (this.isEmpty() || ((Comparable)this.root.element).compareTo(x) != 0) {
            return null;
        }
        return (AnyType)((Comparable)this.root.element);
    }

    public void makeEmpty() {
        this.root = this.nullNode;
    }

    public boolean isEmpty() {
        return this.root == this.nullNode;
    }

    private BinaryNode<AnyType> splay(AnyType x, BinaryNode<AnyType> t) {
        BinaryNode<AnyType> rightTreeMin;
        this.header.right = this.nullNode;
        this.header.left = this.header.right;
        BinaryNode<AnyType> leftTreeMax = rightTreeMin = this.header;
        this.nullNode.element = x;
        while (true) {
            if (x.compareTo(t.element) < 0) {
                if (x.compareTo(t.left.element) < 0) {
                    t = Rotations.rotateWithLeftChild(t);
                }
                if (t.left == this.nullNode) break;
                rightTreeMin.left = t;
                rightTreeMin = t;
                t = t.left;
                continue;
            }
            if (x.compareTo(t.element) <= 0) break;
            if (x.compareTo(t.right.element) > 0) {
                t = Rotations.rotateWithRightChild(t);
            }
            if (t.right == this.nullNode) break;
            leftTreeMax.right = t;
            leftTreeMax = t;
            t = t.right;
        }
        leftTreeMax.right = t.left;
        rightTreeMin.left = t.right;
        t.left = this.header.right;
        t.right = this.header.left;
        return t;
    }

    public static void main(String[] args) {
        SplayTree<Integer> t = new SplayTree<Integer>();
        int NUMS = 40000;
        int GAP = 307;
        System.out.println("Checking... (no bad output means success)");
        int i = 307;
        while (i != 0) {
            t.insert(i);
            i = (i + 307) % 40000;
        }
        System.out.println("Inserts complete");
        for (i = 1; i < 40000; i += 2) {
            t.remove(i);
        }
        System.out.println("Removes complete");
        if ((Integer)t.findMin() != 2 || (Integer)t.findMax() != 39998) {
            System.out.println("FindMin or FindMax error!");
        }
        for (i = 2; i < 40000; i += 2) {
            if (t.find(i) == i) continue;
            System.out.println("Error: find fails for " + i);
        }
        for (i = 1; i < 40000; i += 2) {
            if (t.find(i) == null) continue;
            System.out.println("Error: Found deleted item " + i);
        }
    }
}

