/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.LinkedListIterator;
import weiss.nonstandard.ListNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<AnyType> {
    private ListNode<AnyType> header = new ListNode<Object>(null);

    public boolean isEmpty() {
        return this.header.next == null;
    }

    public void makeEmpty() {
        this.header.next = null;
    }

    public LinkedListIterator<AnyType> zeroth() {
        return new LinkedListIterator<AnyType>(this.header);
    }

    public LinkedListIterator<AnyType> first() {
        return new LinkedListIterator(this.header.next);
    }

    public void insert(AnyType x, LinkedListIterator<AnyType> p) {
        if (p != null && p.current != null) {
            p.current.next = new ListNode<AnyType>(x, p.current.next);
        }
    }

    public LinkedListIterator<AnyType> find(AnyType x) {
        ListNode itr = this.header.next;
        while (itr != null && !itr.element.equals(x)) {
            itr = itr.next;
        }
        return new LinkedListIterator(itr);
    }

    public LinkedListIterator<AnyType> findPrevious(AnyType x) {
        ListNode<AnyType> itr = this.header;
        while (itr.next != null && !itr.next.element.equals(x)) {
            itr = itr.next;
        }
        return new LinkedListIterator<AnyType>(itr);
    }

    public void remove(AnyType x) {
        LinkedListIterator<AnyType> p = this.findPrevious(x);
        if (p.current.next != null) {
            p.current.next = p.current.next.next;
        }
    }

    public static <AnyType> void printList(LinkedList<AnyType> theList) {
        if (theList.isEmpty()) {
            System.out.print("Empty list");
        } else {
            LinkedListIterator<AnyType> itr = theList.first();
            while (itr.isValid()) {
                System.out.print(itr.retrieve() + " ");
                itr.advance();
            }
        }
        System.out.println();
    }

    public static <AnyType> int listSize(LinkedList<AnyType> theList) {
        int size = 0;
        LinkedListIterator<AnyType> itr = theList.first();
        while (itr.isValid()) {
            ++size;
            itr.advance();
        }
        return size;
    }

    public static void main(String[] args) {
        int i;
        LinkedList<Integer> theList = new LinkedList<Integer>();
        LinkedListIterator theItr = theList.zeroth();
        LinkedList.printList(theList);
        for (i = 0; i < 10; ++i) {
            theList.insert(i, theItr);
            LinkedList.printList(theList);
            theItr.advance();
        }
        System.out.println("Size was: " + LinkedList.listSize(theList));
        for (i = 0; i < 10; i += 2) {
            theList.remove(i);
        }
        for (i = 0; i < 10; ++i) {
            if (i % 2 == 0 != theList.find(i).isValid()) continue;
            System.out.println("Find fails!");
        }
        System.out.println("Finished deletions");
        LinkedList.printList(theList);
    }
}

