/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

class DisjointSetsSlow {
    private int[] s;

    public DisjointSetsSlow(int numElements) {
        this.s = new int[numElements];
        for (int i = 0; i < this.s.length; ++i) {
            this.s[i] = -1;
        }
    }

    public void union(int root1, int root2) {
        this.assertIsRoot(root1);
        this.assertIsRoot(root2);
        if (root1 == root2) {
            throw new IllegalArgumentException("Union: root1 == root2 " + root1);
        }
        this.s[root2] = root1;
    }

    public int find(int x) {
        this.assertIsItem(x);
        if (this.s[x] < 0) {
            return x;
        }
        return this.find(this.s[x]);
    }

    private void assertIsRoot(int root) {
        this.assertIsItem(root);
        if (this.s[root] >= 0) {
            throw new IllegalArgumentException("Union: " + root + " not a root");
        }
    }

    private void assertIsItem(int x) {
        if (x < 0 || x >= this.s.length) {
            throw new IllegalArgumentException("Disjoint sets: " + x + " not an item");
        }
    }

    public static void main(String[] args) {
        int numElements = 128;
        int numInSameSet = 16;
        DisjointSetsSlow ds = new DisjointSetsSlow(numElements);
        for (int k = 1; k < numInSameSet; k *= 2) {
            int j = 0;
            while (j + k < numElements) {
                int set1 = ds.find(j);
                int set2 = ds.find(j + k);
                ds.union(set1, set2);
                j += 2 * k;
            }
        }
        for (int i = 0; i < numElements; ++i) {
            System.out.print(ds.find(i) + "*");
            if (i % numInSameSet != numInSameSet - 1) continue;
            System.out.println();
        }
        System.out.println();
    }
}

