/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.PriorityQueue;
import weiss.nonstandard.UnderflowException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryHeap<AnyType extends Comparable<? super AnyType>>
implements PriorityQueue<AnyType> {
    private static final int DEFAULT_CAPACITY = 100;
    private int currentSize;
    private AnyType[] array;

    public BinaryHeap() {
        this.currentSize = 0;
        this.array = new Comparable[101];
    }

    public BinaryHeap(AnyType[] items) {
        this.currentSize = items.length;
        this.array = new Comparable[items.length + 1];
        for (int i = 0; i < items.length; ++i) {
            this.array[i + 1] = items[i];
        }
        this.buildHeap();
    }

    @Override
    public PriorityQueue.Position<AnyType> insert(AnyType x) {
        if (this.currentSize + 1 == this.array.length) {
            this.doubleArray();
        }
        int hole = ++this.currentSize;
        this.array[0] = x;
        while (x.compareTo(this.array[hole / 2]) < 0) {
            this.array[hole] = this.array[hole / 2];
            hole /= 2;
        }
        this.array[hole] = x;
        return null;
    }

    @Override
    public void decreaseKey(PriorityQueue.Position<AnyType> p, AnyType newVal) {
        throw new UnsupportedOperationException("Cannot use decreaseKey for binary heap");
    }

    @Override
    public AnyType findMin() {
        if (this.isEmpty()) {
            throw new UnderflowException("Empty binary heap");
        }
        return this.array[1];
    }

    @Override
    public AnyType deleteMin() {
        AnyType minItem = this.findMin();
        this.array[1] = this.array[this.currentSize--];
        this.percolateDown(1);
        return minItem;
    }

    private void buildHeap() {
        for (int i = this.currentSize / 2; i > 0; --i) {
            this.percolateDown(i);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    @Override
    public int size() {
        return this.currentSize;
    }

    @Override
    public void makeEmpty() {
        this.currentSize = 0;
    }

    private void percolateDown(int hole) {
        AnyType tmp = this.array[hole];
        while (hole * 2 <= this.currentSize) {
            int child = hole * 2;
            if (child != this.currentSize && this.array[child + 1].compareTo(this.array[child]) < 0) {
                ++child;
            }
            if (this.array[child].compareTo(tmp) >= 0) break;
            this.array[hole] = this.array[child];
            hole = child;
        }
        this.array[hole] = tmp;
    }

    private void doubleArray() {
        Comparable[] newArray = new Comparable[this.array.length * 2];
        for (int i = 0; i < this.array.length; ++i) {
            newArray[i] = this.array[i];
        }
        this.array = newArray;
    }

    public static void main(String[] args) {
        int numItems = 10000;
        BinaryHeap<Integer> h1 = new BinaryHeap<Integer>();
        Comparable[] items = new Integer[numItems - 1];
        int i = 37;
        i = 37;
        int j = 0;
        while (i != 0) {
            h1.insert(i);
            items[j] = Integer.valueOf(i);
            i = (i + 37) % numItems;
            ++j;
        }
        for (i = 1; i < numItems; ++i) {
            if ((Integer)h1.deleteMin() == i) continue;
            System.out.println("Oops! " + i);
        }
        BinaryHeap h2 = new BinaryHeap(items);
        for (i = 1; i < numItems; ++i) {
            if ((Integer)h2.deleteMin() == i) continue;
            System.out.println("Oops! " + i);
        }
    }
}

