/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.DuplicateItemException;
import weiss.nonstandard.ItemNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AATree<AnyType extends Comparable<? super AnyType>> {
    private AANode<AnyType> root;
    private AANode<AnyType> nullNode = new AANode<Object>(null, null, null);
    private AANode<AnyType> deletedNode;
    private AANode<AnyType> lastNode;

    public AATree() {
        this.nullNode.right = this.nullNode;
        this.nullNode.left = this.nullNode.right;
        this.nullNode.level = 0;
        this.root = this.nullNode;
    }

    public void insert(AnyType x) {
        this.root = this.insert(x, this.root);
    }

    public void remove(AnyType x) {
        this.deletedNode = this.nullNode;
        this.root = this.remove(x, this.root);
    }

    public AnyType findMin() {
        if (this.isEmpty()) {
            return null;
        }
        AANode<AnyType> ptr = this.root;
        while (ptr.left != this.nullNode) {
            ptr = ptr.left;
        }
        return (AnyType)((Comparable)ptr.element);
    }

    public AnyType findMax() {
        if (this.isEmpty()) {
            return null;
        }
        AANode<AnyType> ptr = this.root;
        while (ptr.right != this.nullNode) {
            ptr = ptr.right;
        }
        return (AnyType)((Comparable)ptr.element);
    }

    public AnyType find(AnyType x) {
        AANode<AnyType> current = this.root;
        this.nullNode.element = x;
        while (true) {
            if (x.compareTo(current.element) < 0) {
                current = current.left;
                continue;
            }
            if (x.compareTo(current.element) <= 0) break;
            current = current.right;
        }
        if (current != this.nullNode) {
            return (AnyType)((Comparable)current.element);
        }
        return null;
    }

    public void makeEmpty() {
        this.root = this.nullNode;
    }

    public boolean isEmpty() {
        return this.root == this.nullNode;
    }

    private AANode<AnyType> insert(AnyType x, AANode<AnyType> t) {
        if (t == this.nullNode) {
            t = new AANode<AnyType>(x, this.nullNode, this.nullNode);
        } else if (x.compareTo(t.element) < 0) {
            t.left = this.insert(x, t.left);
        } else if (x.compareTo(t.element) > 0) {
            t.right = this.insert(x, t.right);
        } else {
            throw new DuplicateItemException(x.toString());
        }
        t = AATree.skew(t);
        t = AATree.split(t);
        return t;
    }

    private AANode<AnyType> remove(AnyType x, AANode<AnyType> t) {
        if (t != this.nullNode) {
            this.lastNode = t;
            if (x.compareTo(t.element) < 0) {
                t.left = this.remove(x, t.left);
            } else {
                this.deletedNode = t;
                t.right = this.remove(x, t.right);
            }
            if (t == this.lastNode) {
                if (this.deletedNode == this.nullNode || x.compareTo(this.deletedNode.element) != 0) {
                    throw new ItemNotFoundException(x.toString());
                }
                this.deletedNode.element = t.element;
                t = t.right;
            } else if (t.left.level < t.level - 1 || t.right.level < t.level - 1) {
                if (t.right.level > --t.level) {
                    t.right.level = t.level;
                }
                t = AATree.skew(t);
                t.right = AATree.skew(t.right);
                t.right.right = AATree.skew(t.right.right);
                t = AATree.split(t);
                t.right = AATree.split(t.right);
            }
        }
        return t;
    }

    private static <AnyType> AANode<AnyType> skew(AANode<AnyType> t) {
        if (t.left.level == t.level) {
            t = AATree.rotateWithLeftChild(t);
        }
        return t;
    }

    private static <AnyType> AANode<AnyType> split(AANode<AnyType> t) {
        if (t.right.right.level == t.level) {
            t = AATree.rotateWithRightChild(t);
            ++t.level;
        }
        return t;
    }

    private static <AnyType> AANode<AnyType> rotateWithLeftChild(AANode<AnyType> k2) {
        AANode k1 = k2.left;
        k2.left = k1.right;
        k1.right = k2;
        return k1;
    }

    private static <AnyType> AANode<AnyType> rotateWithRightChild(AANode<AnyType> k1) {
        AANode k2 = k1.right;
        k1.right = k2.left;
        k2.left = k1;
        return k2;
    }

    public static void main(String[] args) {
        AATree<Integer> t = new AATree<Integer>();
        int NUMS = 40000;
        int GAP = 307;
        System.out.println("Checking... (no bad output means success)");
        t.insert(80000);
        t.insert(120000);
        int i = 307;
        while (i != 0) {
            t.insert(i);
            i = (i + 307) % 40000;
        }
        System.out.println("Inserts complete");
        t.remove((Integer)t.findMax());
        for (i = 1; i < 40000; i += 2) {
            t.remove(i);
        }
        t.remove((Integer)t.findMax());
        System.out.println("Removes complete");
        if ((Integer)t.findMin() != 2 || (Integer)t.findMax() != 39998) {
            System.out.println("FindMin or FindMax error!");
        }
        for (i = 2; i < 40000; i += 2) {
            if (t.find(i) == i) continue;
            System.out.println("Error: find fails for " + i);
        }
        for (i = 1; i < 40000; i += 2) {
            if (t.find(i) == null) continue;
            System.out.println("Error: Found deleted item " + i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AANode<AnyType> {
        AnyType element;
        AANode<AnyType> left;
        AANode<AnyType> right;
        int level;

        AANode(AnyType theElement, AANode<AnyType> lt, AANode<AnyType> rt) {
            this.element = theElement;
            this.left = lt;
            this.right = rt;
            this.level = 1;
        }
    }
}

