/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.Comparator;
import weiss.util.Map;
import weiss.util.MapImpl;
import weiss.util.Set;
import weiss.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMap<KeyType, ValueType>
extends MapImpl<KeyType, ValueType> {
    private Comparator<? super KeyType> keyCmp;

    public TreeMap() {
        super(new TreeSet());
    }

    public TreeMap(Comparator<? super KeyType> comparator) {
        super(new TreeSet());
        this.keyCmp = comparator;
    }

    public TreeMap(Map<KeyType, ValueType> other) {
        super(other);
    }

    public Comparator<? super KeyType> comparator() {
        return this.keyCmp;
    }

    @Override
    protected Map.Entry<KeyType, ValueType> makePair(KeyType key, ValueType value) {
        return new Pair(key, value);
    }

    @Override
    protected Set<KeyType> makeEmptyKeySet() {
        return new TreeSet<KeyType>(this.keyCmp);
    }

    @Override
    protected Set<Map.Entry<KeyType, ValueType>> clonePairSet(Set<Map.Entry<KeyType, ValueType>> pairSet) {
        return new TreeSet<Map.Entry<KeyType, ValueType>>(pairSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Pair
    extends MapImpl.Pair<KeyType, ValueType>
    implements Comparable<Map.Entry<KeyType, ValueType>> {
        public Pair(KeyType k, ValueType v) {
            super(k, v);
        }

        @Override
        public int compareTo(Map.Entry<KeyType, ValueType> other) {
            if (TreeMap.this.keyCmp != null) {
                return TreeMap.this.keyCmp.compare(this.getKey(), other.getKey());
            }
            return ((Comparable)this.getKey()).compareTo(other.getKey());
        }
    }
}

