/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Random31 {
    private static final int A = 48271;
    private static final int M = Integer.MAX_VALUE;
    private static final int Q = 44488;
    private static final int R = 3399;
    private int state;

    public Random31() {
        this((int)(System.nanoTime() % Integer.MAX_VALUE));
    }

    public Random31(int initialValue) {
        if (initialValue < 0) {
            initialValue += Integer.MAX_VALUE;
            ++initialValue;
        }
        this.state = initialValue;
        if (this.state <= 0) {
            this.state = 1;
        }
    }

    public int nextInt() {
        int tmpState = 48271 * (this.state % 44488) - 3399 * (this.state / 44488);
        this.state = tmpState >= 0 ? tmpState : tmpState + Integer.MAX_VALUE;
        return this.state;
    }

    public int nextInt(int high) {
        return (int)(this.nextLong() % (long)high);
    }

    public int nextIntWRONG() {
        this.state = 48271 * this.state % Integer.MAX_VALUE;
        return this.state;
    }

    public double nextDouble() {
        return (double)this.nextInt() / 2.147483647E9;
    }

    public int nextInt(int low, int high) {
        double partitionSize = 2.147483647E9 / (double)(high - low + 1);
        return (int)((double)this.nextInt() / partitionSize) + low;
    }

    public long nextLong() {
        return ((long)this.nextInt() - 1L << 31) + (long)this.nextInt();
    }

    public int nextPoisson(double expectedValue) {
        double limit = -expectedValue;
        double product = Math.log(this.nextDouble());
        int count = 0;
        while (product > limit) {
            product += Math.log(this.nextDouble());
            ++count;
        }
        return count;
    }

    public double nextNegExp(double expectedValue) {
        return -expectedValue * Math.log(this.nextDouble());
    }

    private static final <AnyType> void swapReferences(AnyType[] a, int index1, int index2) {
        AnyType tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static final <AnyType> void permute(AnyType[] a) {
        Random r = new Random();
        for (int j = 1; j < a.length; ++j) {
            Random31.swapReferences(a, j, r.nextInt(0, j));
        }
    }

    public static void main(String[] args) {
        int i;
        Random31 r = new Random31();
        for (int i2 = 0; i2 < 20; ++i2) {
            System.out.println(r.nextInt());
        }
        int[] dist = new int[10000];
        int SAMPLES = 100000000;
        for (i = 0; i < 100000000; ++i) {
            int n = r.nextPoisson(2.0);
            dist[n] = dist[n] + 1;
        }
        for (i = 0; i < 10; ++i) {
            System.out.println(i + ": " + (double)dist[i] / 1.0E8);
        }
    }
}

