/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.Iterator;
import weiss.util.Map;
import weiss.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MapImpl<KeyType, ValueType>
implements Map<KeyType, ValueType> {
    private Set<Map.Entry<KeyType, ValueType>> theSet;

    protected abstract Map.Entry<KeyType, ValueType> makePair(KeyType var1, ValueType var2);

    protected abstract Set<KeyType> makeEmptyKeySet();

    protected abstract Set<Map.Entry<KeyType, ValueType>> clonePairSet(Set<Map.Entry<KeyType, ValueType>> var1);

    private Map.Entry<KeyType, ValueType> makePair(KeyType key) {
        return this.makePair(key, null);
    }

    protected MapImpl(Set<Map.Entry<KeyType, ValueType>> s) {
        this.theSet = s;
    }

    protected MapImpl(Map<KeyType, ValueType> m) {
        this.theSet = this.clonePairSet(m.entrySet());
    }

    @Override
    public int size() {
        return this.theSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theSet.isEmpty();
    }

    @Override
    public boolean containsKey(KeyType key) {
        return this.theSet.contains(this.makePair(key));
    }

    @Override
    public ValueType get(KeyType key) {
        Map.Entry<KeyType, ValueType> match = this.theSet.getMatch(this.makePair(key));
        if (match == null) {
            return null;
        }
        return match.getValue();
    }

    @Override
    public ValueType put(KeyType key, ValueType value) {
        Map.Entry<KeyType, ValueType> match = this.theSet.getMatch(this.makePair(key));
        if (match != null) {
            return match.setValue(value);
        }
        this.theSet.add(this.makePair(key, value));
        return null;
    }

    @Override
    public ValueType remove(KeyType key) {
        ValueType oldValue = this.get(key);
        if (oldValue != null) {
            this.theSet.remove(this.makePair(key));
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.theSet.clear();
    }

    @Override
    public Set<KeyType> keySet() {
        return new KeySetClass();
    }

    @Override
    public Collection<ValueType> values() {
        return new ValueCollectionClass();
    }

    @Override
    public Set<Map.Entry<KeyType, ValueType>> entrySet() {
        return this.getSet();
    }

    protected Set<Map.Entry<KeyType, ValueType>> getSet() {
        return this.theSet;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{");
        for (Map.Entry entry : this.entrySet()) {
            result.append(entry + ", ");
        }
        result.replace(result.length() - 2, result.length(), "}");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class Pair<KeyType, ValueType>
    implements Map.Entry<KeyType, ValueType> {
        private KeyType key;
        private ValueType value;

        public Pair(KeyType k, ValueType v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public final KeyType getKey() {
            return this.key;
        }

        @Override
        public final ValueType getValue() {
            return this.value;
        }

        @Override
        public final ValueType setValue(ValueType newValue) {
            ValueType oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueCollectionIterator
    implements Iterator<ValueType> {
        private Iterator<Map.Entry<KeyType, ValueType>> itr;

        private ValueCollectionIterator() {
            this.itr = MapImpl.this.theSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }

        @Override
        public ValueType next() {
            return this.itr.next().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySetIterator
    implements Iterator<KeyType> {
        private Iterator<Map.Entry<KeyType, ValueType>> itr;

        private KeySetIterator() {
            this.itr = MapImpl.this.theSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }

        @Override
        public KeyType next() {
            return this.itr.next().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueCollectionClass
    extends ViewClass<ValueType> {
        private ValueCollectionClass() {
        }

        @Override
        public Iterator<ValueType> iterator() {
            return new ValueCollectionIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySetClass
    extends ViewClass<KeyType>
    implements Set<KeyType> {
        private KeySetClass() {
        }

        @Override
        public boolean remove(Object key) {
            return MapImpl.this.remove(key) != null;
        }

        @Override
        public Iterator<KeyType> iterator() {
            return new KeySetIterator();
        }

        @Override
        public KeyType getMatch(KeyType key) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ViewClass<AnyType>
    extends AbstractCollection<AnyType> {
        private ViewClass() {
        }

        @Override
        public int size() {
            return MapImpl.this.size();
        }

        @Override
        public void clear() {
            MapImpl.this.clear();
        }
    }
}

