/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.ConcurrentModificationException;
import weiss.util.Iterator;
import weiss.util.List;
import weiss.util.ListIterator;
import weiss.util.NoSuchElementException;
import weiss.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<AnyType>
extends AbstractCollection<AnyType>
implements List<AnyType>,
Queue<AnyType> {
    private final Node<AnyType> NOT_FOUND = null;
    private int theSize;
    private Node<AnyType> beginMarker;
    private Node<AnyType> endMarker;
    private int modCount = 0;

    public LinkedList() {
        this.clear();
    }

    public LinkedList(Collection<? extends AnyType> other) {
        this.clear();
        for (Object val : other) {
            this.add(val);
        }
    }

    @Override
    public void clear() {
        this.beginMarker = new Node<Object>(null, null, null);
        this.endMarker = new Node<Object>(null, this.beginMarker, null);
        this.beginMarker.next = this.endMarker;
        this.theSize = 0;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.theSize;
    }

    @Override
    public boolean contains(Object x) {
        return this.findPos(x) != this.NOT_FOUND;
    }

    private Node<AnyType> findPos(Object x) {
        Node p = this.beginMarker.next;
        while (p != this.endMarker) {
            if (x == null ? p.data == null : x.equals(p.data)) {
                return p;
            }
            p = p.next;
        }
        return this.NOT_FOUND;
    }

    @Override
    public boolean add(AnyType x) {
        this.addLast(x);
        return true;
    }

    public void add(int idx, AnyType x) {
        Node<AnyType> p = this.getNode(idx, 0, this.size());
        Node<AnyType> newNode = new Node<AnyType>(x, p.prev, p);
        newNode.prev.next = newNode;
        p.prev = newNode;
        ++this.theSize;
        ++this.modCount;
    }

    public void addFirst(AnyType x) {
        this.add(0, x);
    }

    public void addLast(AnyType x) {
        this.add(this.size(), x);
    }

    @Override
    public AnyType element() {
        return this.getFirst();
    }

    public AnyType getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getNode((int)0).data;
    }

    public AnyType getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getNode((int)(this.size() - 1)).data;
    }

    @Override
    public AnyType get(int idx) {
        return this.getNode((int)idx).data;
    }

    @Override
    public AnyType set(int idx, AnyType newVal) {
        Node<AnyType> p = this.getNode(idx);
        Object oldVal = p.data;
        p.data = newVal;
        return oldVal;
    }

    @Override
    public AnyType remove() {
        return this.removeFirst();
    }

    public AnyType removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.remove(this.getNode(0));
    }

    public AnyType removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.remove(this.getNode(this.size() - 1));
    }

    @Override
    public boolean remove(Object x) {
        Node<AnyType> pos = this.findPos(x);
        if (pos == this.NOT_FOUND) {
            return false;
        }
        this.remove(pos);
        return true;
    }

    private Node<AnyType> getNode(int idx) {
        return this.getNode(idx, 0, this.size() - 1);
    }

    private Node<AnyType> getNode(int idx, int lower, int upper) {
        Node<AnyType> p;
        if (idx < lower || idx > upper) {
            throw new IndexOutOfBoundsException("getNode index: " + idx + "; size: " + this.size());
        }
        if (idx < this.size() / 2) {
            p = this.beginMarker.next;
            for (int i = 0; i < idx; ++i) {
                p = p.next;
            }
        } else {
            p = this.endMarker;
            for (int i = this.size(); i > idx; --i) {
                p = p.prev;
            }
        }
        return p;
    }

    public AnyType remove(int idx) {
        return this.remove(this.getNode(idx));
    }

    private AnyType remove(Node<AnyType> p) {
        p.next.prev = p.prev;
        p.prev.next = p.next;
        --this.theSize;
        ++this.modCount;
        return p.data;
    }

    @Override
    public Iterator<AnyType> iterator() {
        return new LinkedListIterator(0);
    }

    @Override
    public ListIterator<AnyType> listIterator(int idx) {
        return new LinkedListIterator(idx);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<AnyType> {
        public AnyType data;
        public Node<AnyType> prev;
        public Node<AnyType> next;

        public Node(AnyType d, Node<AnyType> p, Node<AnyType> n) {
            this.data = d;
            this.prev = p;
            this.next = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LinkedListIterator
    implements ListIterator<AnyType> {
        private Node<AnyType> current;
        private Node<AnyType> lastVisited = null;
        private boolean lastMoveWasPrev = false;
        private int expectedModCount = LinkedList.access$000(LinkedList.this);

        public LinkedListIterator(int idx) {
            this.current = LinkedList.this.getNode(idx, 0, LinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current != LinkedList.this.endMarker;
        }

        @Override
        public AnyType next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object nextItem = this.current.data;
            this.lastVisited = this.current;
            this.current = this.current.next;
            this.lastMoveWasPrev = false;
            return nextItem;
        }

        @Override
        public void remove() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastVisited == null) {
                throw new IllegalStateException();
            }
            LinkedList.this.remove(this.lastVisited);
            this.lastVisited = null;
            if (this.lastMoveWasPrev) {
                this.current = this.current.next;
            }
            ++this.expectedModCount;
        }

        @Override
        public boolean hasPrevious() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current != ((LinkedList)LinkedList.this).beginMarker.next;
        }

        @Override
        public AnyType previous() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.current = this.current.prev;
            this.lastVisited = this.current;
            this.lastMoveWasPrev = true;
            return this.current.data;
        }
    }
}

