/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import java.io.Serializable;
import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.ConcurrentModificationException;
import weiss.util.Iterator;
import weiss.util.NoSuchElementException;
import weiss.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashSet<AnyType>
extends AbstractCollection<AnyType>
implements Set<AnyType> {
    private static final int DEFAULT_TABLE_SIZE = 101;
    private int currentSize = 0;
    private int occupied = 0;
    private int modCount = 0;
    private HashEntry[] array;

    public HashSet() {
        this.allocateArray(101);
        this.clear();
    }

    public HashSet(Collection<? extends AnyType> other) {
        this.allocateArray(HashSet.nextPrime(other.size() * 2));
        this.clear();
        for (Object val : other) {
            this.add(val);
        }
    }

    @Override
    public int size() {
        return this.currentSize;
    }

    @Override
    public AnyType getMatch(AnyType x) {
        int currentPos = this.findPos(x);
        if (HashSet.isActive(this.array, currentPos)) {
            return (AnyType)this.array[currentPos].element;
        }
        return null;
    }

    @Override
    public boolean contains(Object x) {
        return HashSet.isActive(this.array, this.findPos(x));
    }

    private static boolean isActive(HashEntry[] arr, int pos) {
        return arr[pos] != null && arr[pos].isActive;
    }

    @Override
    public boolean add(AnyType x) {
        int currentPos = this.findPos(x);
        if (HashSet.isActive(this.array, currentPos)) {
            return false;
        }
        if (this.array[currentPos] == null) {
            ++this.occupied;
        }
        this.array[currentPos] = new HashEntry(x, true);
        ++this.currentSize;
        ++this.modCount;
        if (this.occupied > this.array.length / 2) {
            this.rehash();
        }
        return true;
    }

    private void rehash() {
        HashEntry[] oldArray = this.array;
        this.allocateArray(HashSet.nextPrime(4 * this.size()));
        this.currentSize = 0;
        this.occupied = 0;
        for (int i = 0; i < oldArray.length; ++i) {
            if (!HashSet.isActive(oldArray, i)) continue;
            this.add(oldArray[i].element);
        }
    }

    @Override
    public boolean remove(Object x) {
        int currentPos = this.findPos(x);
        if (!HashSet.isActive(this.array, currentPos)) {
            return false;
        }
        this.array[currentPos].isActive = false;
        --this.currentSize;
        ++this.modCount;
        if (this.currentSize < this.array.length / 8) {
            this.rehash();
        }
        return true;
    }

    @Override
    public void clear() {
        this.occupied = 0;
        this.currentSize = 0;
        ++this.modCount;
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
    }

    @Override
    public Iterator<AnyType> iterator() {
        return new HashSetIterator();
    }

    private int findPos(Object x) {
        int currentPos;
        int offset = 1;
        int n = currentPos = x == null ? 0 : Math.abs(x.hashCode() % this.array.length);
        while (this.array[currentPos] != null && !(x == null ? this.array[currentPos].element == null : x.equals(this.array[currentPos].element))) {
            if ((currentPos += (offset += 2)) < this.array.length) continue;
            currentPos -= this.array.length;
        }
        return currentPos;
    }

    private void allocateArray(int arraySize) {
        this.array = new HashEntry[HashSet.nextPrime(arraySize)];
    }

    private static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!HashSet.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= n) {
            if (n % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    private static class HashEntry
    implements Serializable {
        public Object element;
        public boolean isActive;

        public HashEntry(Object e) {
            this(e, true);
        }

        public HashEntry(Object e, boolean i) {
            this.element = e;
            this.isActive = i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HashSetIterator
    implements Iterator<AnyType> {
        private int expectedModCount;
        private int currentPos;
        private int visited;

        private HashSetIterator() {
            this.expectedModCount = HashSet.this.modCount;
            this.currentPos = -1;
            this.visited = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.expectedModCount != HashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.visited != HashSet.this.size();
        }

        @Override
        public AnyType next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            do {
                ++this.currentPos;
            } while (this.currentPos < HashSet.this.array.length && !HashSet.isActive(HashSet.this.array, this.currentPos));
            ++this.visited;
            return ((HashSet)HashSet.this).array[this.currentPos].element;
        }

        @Override
        public void remove() {
            if (this.expectedModCount != HashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.currentPos == -1 || !HashSet.isActive(HashSet.this.array, this.currentPos)) {
                throw new IllegalStateException();
            }
            ((HashSet)HashSet.this).array[this.currentPos].isActive = false;
            HashSet.this.currentSize--;
            --this.visited;
            HashSet.this.modCount++;
            ++this.expectedModCount;
        }
    }
}

