import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.JPanel;


/**
 * a panel of ToolButtons
 *
 * @author Matt Drosos and Colin DeClue.
 *         Created Apr 7, 2008.
 */
public class ToolPanel extends JPanel{
	
	private Tool currentTool;
	private ArrayList<Shape> shapes;
	
	/**
	 * constructs a panel of ToolButtons
	 *
	 * @param shapes an ArrayList of shapes drawn to the worldPanel
	 * @param fill an ArrayList of booleans telling whether to fill the shape or not
	 * @param color Background color for this ToolPanel.
	 * @param colorPanel allows communication between colorPanel and WorldPanel
	 * @param panels allows communication between ToolPanel and WorldPanel
	 */
	public ToolPanel(ArrayList<Shape> shapes, ArrayList<Boolean> fill, ArrayList<Color> color, ColorPanel colorPanel, ArrayList<WorldPanel> panels)
	{
		this.shapes = shapes;
		this.currentTool = new Pencil(this.shapes, fill, color, colorPanel);
		GridLayout grid = new GridLayout(2, 6);
		//pencil button
		ToolButton pencil = new ToolButton(this, new Pencil(this.shapes, fill, color, colorPanel));
		pencil.setText("Pencil");
		pencil.addActionListener(pencil);
		//brush button
		ToolButton brush = new ToolButton(this, new Brush(this.shapes, fill, color, colorPanel));
		brush.setText("Brush");
		brush.addActionListener(brush);
		//graffiti can button
		ToolButton can = new ToolButton(this, new GraffitiCan(this.shapes, fill, color, colorPanel));
		can.setText("Graffiti Can");
		can.addActionListener(can);
		//oval button
		ToolButton oval = new ToolButton(this, new Oval(this.shapes, fill, color, colorPanel, panels));
		oval.setText("Oval");
		oval.addActionListener(oval);
		//rectangle button
		ToolButton rect = new ToolButton(this, new Rectangle(this.shapes, fill, color, colorPanel, panels));
		rect.setText("Rectangle");
		rect.addActionListener(rect);
		//erase button
		ToolButton erase = new ToolButton(this, new Eraser(this.shapes, fill, color, colorPanel));
		erase.setText("Eraser");
		erase.addActionListener(erase);
		//filled rect button
		ToolButton filledRect = new ToolButton(this, new FilledRectangle(this.shapes, fill, color, colorPanel, panels));
		filledRect.setText("Filled Rectangle");
		filledRect.addActionListener(filledRect);
		//filled oval button
		ToolButton filledOval = new ToolButton(this, new FilledOval(this.shapes, fill, color, colorPanel, panels));
		filledOval.setText("Filled Oval");
		filledOval.addActionListener(filledOval);
		//calligraphy pen button
		ToolButton callig = new ToolButton(this, new CalligraphyPen(this.shapes, fill, color, colorPanel));
		callig.setText("Calligraphy Pen");
		callig.addActionListener(callig);
		//reset button
		ResetButton reset = new ResetButton(panels);
		reset.setText("Reset");
		reset.addActionListener(reset);
		//undo button
		UndoButton undo = new UndoButton(this.shapes, fill, color, panels, this.currentTool);
		undo.setText("Undo");
		undo.addActionListener(undo);
//		polygon button
		ToolButton poly = new ToolButton(this, new Polygon(this.shapes, fill, color, colorPanel));
		poly.setText("Polygon");
		poly.setToolTipText("end by clicking within a 5 pixel radius of the start point");
		poly.addActionListener(poly);
		
		
		this.add(reset);
		this.add(callig);
		this.add(filledOval);
		this.add(filledRect);
		this.add(erase);
		this.add(rect);
		this.add(oval);
		this.add(can);
		this.add(brush);
		this.add(pencil);
		this.add(undo);
		this.add(poly);
		this.setLayout(grid);
	}
	
	/**
	 * 
	 * @return - returns the currentTool being used
	 */
	public Tool getCurrentTool()
	{
		return this.currentTool;
	}
	
	/**
	 * sets the currentTool to a new currentTool value
	 *
	 * @param currentTool
	 */
	public void setCurrentTool(Tool currentTool)
	{
		this.currentTool = currentTool;
	}
	
}
