import java.awt.Color;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;


/**
 * the button that is clicked to reset the screen
 *
 * @author Matt Drosos and Colin DeClue.
 *         Created Apr 14, 2008.
 */
public class ResetButton extends JButton implements ActionListener {
	private ArrayList<WorldPanel> panels;

	
	/**
	 * creates a filled rectangle of the given color
	 *
	 * @param shapes - an ArrayList of shapes drawn to the panel
	 * @param fill - an ArrayList of booleans that determine if the shape should be filled
	 * @param colors - an ArrayList of colors of the corresponding shapes
	 * @param panels - an ArrayList of panels in the WorldPanel
	 */
	public ResetButton(ArrayList<WorldPanel> panels)
	{
		this.panels = panels;
	}
	
	public void actionPerformed(ActionEvent arg0) {
		this.panels.get(0).reset();
	}

}
