import java.awt.geom.Line2D;
import java.awt.geom.Path2D;


/**
 * Brush tool
 *
 * @author Richard Stover.
 *         Created Apr 9, 2008.
 */
public class Brush implements Tools{
	
	private Path2D path;

	/**
	 * creates a brush object
	 *
	 * @param x
	 * @param y
	 */
	public Brush(int x, int y) {
		Line2D line = new Line2D.Double(x,y,x,y);
		this.path = new Path2D.Double(line);
	}

	/**
	 * draws the brush
	 * 
	 * @param x 
	 * @param y 
	 * @return Line drawn with Brush in Path2D
	 */
	public Path2D draw(int x, int y) {
		this.path.lineTo(x,y);
		return this.path;
	}

}