import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;


/**
 * this class makes a tool that makes a rectangle on the screen that only it can be modified until all pixels are deselected
 *
 * @author Bryan Warner
 *         Created Apr 10, 2008.
 */
public class RectangleSelectTool extends Tool{
	/**
	 * creates the tool to select a rectangle are to modify
	 *
	 */
	public RectangleSelectTool(){
		super(20,new File("rectangleselect.bmp"),"rectangle select");			
	}
		
		
	@Override
	public void finish(){
		this.x=-1;
		this.y=-1;
		Graphics2D g  = this.c.getImage().createGraphics();
		g.setColor(this.c.getPaint().cc.getColor());
		BufferedImage buf = this.c.getImage();
		int w=buf.getWidth();
		int h=buf.getHeight();
		for(int i=0;i<w;i++){
			for(int j=0;j<h;j++){
				if(this.c.getShape().contains(new Point2D.Double(i,j))){
					this.c.select(i,j);
				}
			}
		}
		
		this.c.repaint();
	}
	@Override
	public void Paint(Canvas c, int x, int y){
		if(this.x != -1 && this.y != -1){
			BufferedImage buf = this.c.getImage();
			int w=buf.getWidth();
			int h=buf.getHeight();
			for(int i=0;i<w;i++){
				for(int j=0;j<h;j++){
					this.c.deselect(i,j);
				}
			}
			Rectangle2D.Double e = new Rectangle2D.Double(this.x,this.y,x-this.x,y-this.y);
			this.c.setShape(e);
		}
		else{
		this.c = c;
		this.x = x;
		this.y = y;
		}
	}

}