import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;


/**
 * Defines each color button.
 *
 * @author Annmarie Stanley and Hannah Chadd.
 *         Created Mar 30, 2008.
 */
public class ColorButton extends JButton implements ActionListener, MouseListener{
	
	private Dimension dim = new Dimension(20,20);
	private Color color;
	
	
/**
 * Given a color, creates a color button with constant dimension. 
 * Accessor method included. 
 *
 * @param color
 */
//	@SuppressWarnings("deprecation")
	public ColorButton(Color color) {
		super();
		this.color = color;
		this.setBackground(color);
		this.setPreferredSize(this.dim);
	}
	
	/**
	 * @return the button's color
	 */
	public Color getColor() {
		return this.color;
	}

	public void actionPerformed(ActionEvent arg0) {
		// TODO Auto-generated method stub.
		
	}

	public void mouseClicked(MouseEvent arg0) {
		ColorPanel.current = this.getColor();		
		for (int j = 0; j < ColorPanel.COLOR_LIST.length; j++) {
			if (this.color.equals(ColorPanel.COLOR_LIST[j])) {
				CanvasPanel.changeColor(j);
			}
		}
	}

	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mouseReleased(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}
	

}
