import javax.swing.JFrame;
import javax.swing.JTextArea;


/**
 * Frame that tells people how to play around with our Paint program.
 *
 * @author Caz Ksiazek.
 *         Created Apr 14, 2008.
 */
public class HelpFrame extends JFrame {
	
	private static final int FRAME_WIDTH = 700;
	private static final int FRAME_HEIGHT = 300;
	
	/**
	 * Creates a frame that includes documentation for how to use our program.
	 *
	 */
	protected HelpFrame() {
		this.setSize(FRAME_WIDTH,FRAME_HEIGHT);
		this.setTitle("Paint \"Help\" - Team 101");
		
		JTextArea ourText = new JTextArea("Welcome to Paint! \n\n" +
				"Sliders: \n" +
				"Size: Adjusts the size of the Brush, Rectangle, Oval, SprayPaint, and Eraser tools.\n" +
				"RGB Colors: Adjusts the Red, Green, and Blue color values for the drawing tools. Values range from 0 to 255.\n\n" +
				"Shift Key: Use the shift key to constrain rectangles to squares and ovals to circles, respectively.\n" +
				"You will have the ability to move these squares and circles up and down somewhat, due to another degree of freedom.\n\n" +
				"Shift Key 2: When using the polygon tool, to finish drawing and close your polygon, hold shift and drag the mouse.\n\n" +
				"Undo Tool: Instead of only being able to undo one drawing at a time, you have the ability to undo as much as you want.\n" +
				"To do this, click Undo and go use it in the draw area as a regular brush or pencil, and watch what happens.\n\n" +
				"Thanks for playing! - C. Ksiazek & B. Borchers");
		
		this.add(ourText);
		
		this.setVisible(true);
	}
}
