import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JPanel;

/**
 * This class creates the buttons where it will let the user choose the kinds
 * of tools in Paint program.
 *
 * @author baekj.
 *         Created Apr 7, 2008.
 */
public class WritingToolsPanel extends JPanel {
	private DrawingPanel bla;

	private static final int W_PANEL_HEIGHT = 600;

	private static final int W_PANEL_WIDTH = 200;

	private static final int B_PANEL_HEIGHT = 50;

	private static final int B_PANEL_WIDTH = 50;

	private GridBagLayout layout;

	/**
	 * This constructor creates the panel and adds the buttons in GridBagLayout.
	 *
	 * @param bla the instance of the panel for drawing. This is brought into 
	 * this class so that the changes in made in this class can affect the 
	 * drawing panel. 
	 */
	public WritingToolsPanel(DrawingPanel bla) {
		super();
		this.bla = bla;
		//configure panel
		this.setBackground(Color.BLACK);
		this.setSize(W_PANEL_WIDTH, W_PANEL_HEIGHT);
		this.layout = new GridBagLayout();
		this.addDefaultButtons();

		this.setVisible(true);

	}

	/**
	 * Declares and adds the buttons into the panel.
	 *
	 */
	public void addDefaultButtons() {

		this.setLayout(this.layout);
		GridBagConstraints c = new GridBagConstraints();

		//declare buttons
		BrushButton brush = new BrushButton(this.bla);
		brush.setText("Brush");

		Circle circle = new Circle(this.bla);
		circle.setText("Cirlce");

		Rectangle rectangle = new Rectangle(this.bla);
		rectangle.setText("Rectangle");

		Polygon polygon = new Polygon(this.bla);
		polygon.setText("Polygon");

		PencilButton pencil = new PencilButton(this.bla);
		pencil.setText("Pencil");
		
		SprayUndoClear clear = new SprayUndoClear(this.bla, 0);
		clear.setText("Clear Image");
		
		SprayUndoClear spray = new SprayUndoClear(this.bla, 1);
		spray.setText("Spray");
		
		SprayUndoClear undo = new SprayUndoClear(this.bla, 2);
		undo.setText("Undo");

		//set the button's size
		brush.setSize(B_PANEL_WIDTH, B_PANEL_HEIGHT);
		rectangle.setSize(B_PANEL_WIDTH, B_PANEL_HEIGHT);
		clear.setSize(B_PANEL_WIDTH,B_PANEL_HEIGHT);
		polygon.setSize(B_PANEL_WIDTH, B_PANEL_HEIGHT);
		pencil.setSize(B_PANEL_WIDTH, B_PANEL_HEIGHT);
		circle.setSize(B_PANEL_WIDTH, B_PANEL_HEIGHT);
		spray.setSize(B_PANEL_WIDTH,B_PANEL_HEIGHT);
		clear.setSize(B_PANEL_WIDTH,B_PANEL_HEIGHT);

		//add actionlistener.
		brush.addActionListener(brush);
		polygon.addActionListener(polygon);
		rectangle.addActionListener(rectangle);
		circle.addActionListener(circle);
		pencil.addActionListener(pencil);
		spray.addActionListener(spray);
		undo.addActionListener(undo);
		clear.addActionListener(clear);

		//	add buttons
		c.fill = GridBagConstraints.HORIZONTAL;
		c.gridx = 0;
		c.gridy = 0;
		this.add(brush, c);
		c.gridx = 1;
		c.gridy = 0;
		this.add(pencil, c);
		c.gridx = 0;
		c.gridy = 1;
		this.add(polygon, c);
		c.gridx = 1;
		c.gridy = 1;
		this.add(rectangle, c);
		c.gridx = 0;
		c.gridy = 2;
		this.add(circle, c);
		c.gridx = 1;
		c.gridy = 2;
		this.add(clear, c);
		c.gridx = 0;
		c.gridy = 3;
		this.add(spray,c);
		c.gridx = 1;
		c.gridy = 3;
		this.add(undo,c);
	}

}
