import java.awt.BorderLayout;

import javax.swing.JFrame;


/**
 * This class trys to mimic Microsoft's paint program.
 *
 * @author <Michael Crane and Jinwoo Baek>.
 *         Started work <March 26, 2008>
 */
public class Paint extends JFrame{
	private static final int FRAME_HEIGHT = 800;
	private static final int FRAME_WIDTH = 800;
	private WritingToolsPanel writing;
	private DrawingPanel drawing;
	private BorderLayout layout;
	
	/**
	 * This creates the frame and all the panels in the program.
	 *
	 */
	public Paint(){
		super();
		this.drawing = new DrawingPanel();
		this.writing = new WritingToolsPanel(this.drawing);
		ColorSelectionPanel colorSelection = new ColorSelectionPanel(this.drawing);
		SubFunctionPanel sub = new SubFunctionPanel(this.drawing);
		
		this.layout = new BorderLayout();
		this.setLayout(this.layout);
		
		this.add(sub, BorderLayout.NORTH);
		this.add(this.drawing, BorderLayout.CENTER);
		this.add(this.writing, BorderLayout.WEST);
		this.add(colorSelection, BorderLayout.SOUTH);
	}
	/**
	 * Start here.
	 *
	 * @param args
	 */
	public static void main(String[] args) {
		Paint frame = new Paint();
		frame.setSize(FRAME_WIDTH,FRAME_HEIGHT);
		frame.setTitle("Paint");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setVisible(true);
	}
}