import java.awt.Color;
import java.awt.Shape;


/**
 * Contains components to draw on the drawingpanel, may be shapes or text.
 * 
 * @author Bryan Cobb, Jon Klein
 *         Created Apr 11, 2008.
 */
public class doodle {
	
	/**
	 * shape to be drawn.
	 */
	protected Shape shape;
	/**
	 * color of shape.
	 */
	protected Color color;
	/**
	 * size or width of lines of shape.
	 */
	protected int size;
	protected Color fillcolor = Color.white;
	/**
	 * Field to display if the doodle is text or not, used to handle drawing it.
	 */
	public boolean text = false;
	protected int x;
	protected int y;
	private String message;
	/** 
	 * Field to indicate if the object is to be filled or not.
	 */
	public boolean filled = false;
	
	protected String fontface;
	protected int fontstyle;

	/**
	 * constructor of doodle
	 *
	 * @param shape Shape to hold.
	 * @param color Outlne color.
	 * @param size  Width of outline.
	 */
	public doodle(Shape shape, Color color, int size) {
		this.shape = shape;
		this.color = color;
		this.size = size;
	}
	
	/**
	 * constructor of doodle.
	 *
	 * @param shape Shape to draw.
	 * @param color Color of outline.
	 * @param size  Width of outline.
	 * @param fillcolor  Color to fill.
	 * @param fillshapes  If it is to be filled or not.
	 */
	public doodle(Shape shape, Color color, int size, Color fillcolor, boolean fillshapes) {
		this.shape = shape;
		this.color = color;
		this.size = size;
		this.fillcolor = fillcolor;
		this.filled = fillshapes;
	}
	
	/**
	 * A text doodle, stores a string of text to go on the panel.
	 * @param text The text to display.
	 * @param color The color of the text.
	 * @param x X posisiston on the panel.
	 * @param y Y posistion on the panel.
	 * @param fontstyle Font style, from Font.[style]
	 * @param fontsize  Font size, integer, should be near 12
	 * @param fontface  Font face, eg. TimesRoman
	 */
	public doodle(String text, Color color, int x, int y, int fontstyle, int fontsize, String fontface)
	{
		this.text = true;
		this.x = x;
		this.y = y;
		this.color = color;
		this.message = text;
		this.fontface = fontface;
		this.size = fontsize;
		this.fontstyle = fontstyle;
		
	}
	
	
	/**
	 * @return shape The shape of a doodle, may break if it is a text doodle.
	 */
	public Shape getShape() {
		return this.shape;
	}
	
	/**
	 * @return color The color of the doodle.
	 */
	public Color getColor() {
		return this.color;
	}
	
	/**
	 * Sets the color of the doodle for future redraws.
	 * @param color
	 */
	public void setColor(Color color)
	{
		this.color = color;
	}
	
	/**
	 * The size of the outline
	 * @return size
	 */
	public int getSize() {
		return this.size;
	}
	
	/**
	 * @return The content of a text doodle string.
	 */
	public String getMessage()
	{
		return this.message;
	}
	
	/**
	 * @return The font face of a text doodle.
	 */
	public String getFace()
	{
		return this.fontface;
	}
	
	/**
	 * @return The style of a text doodle.
	 */
	public int getStyle()
	{
		return this.fontstyle;
	}

	

}
