import java.awt.BorderLayout;

import javax.swing.JFrame;

/**
 * Creates a Paint frame in which you can select from many tools and colors to
 * paint an image.
 *
 * @author Rich Stover, Mark Swanson
 *         Started work 04/08/08
 */
public class Paint {

	/**
	 * Start here.
	 *
	 * @param args
	 */
	public static void main(String[] args) {
		JFrame paint = new JFrame();
		paint.setSize(1000,1000);
		paint.setTitle("Paint!");
		paint.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		paint.setLayout(new BorderLayout());
		CanvasPanel canvas = new CanvasPanel();
		ToolPanel tools = new ToolPanel(canvas);
		ColorPanel colors = new ColorPanel(canvas);
		MenuBar menu = new MenuBar(canvas);
		tools.setColor(colors);
		ToolButtonPanel toolButtons = tools.getToolButtonPanel();
		DisplayPanel display = tools.getDisplayPanel();
		toolButtons.setCanvas(canvas);
		display.setCanvas(canvas);
		canvas.setDisplay(display);
		paint.add(canvas, BorderLayout.CENTER);
		paint.add(colors, BorderLayout.SOUTH);
		paint.add(tools, BorderLayout.WEST);
		paint.setJMenuBar(menu.getJMenuBar());
		paint.setVisible(true);
	}

}
