import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;


/**
 * tool button extension of JButton class
 *
 * @author Joe Wanstrath.
 *         Created Apr 7, 2008.
 */
public class ToolButton extends JButton implements ActionListener{
	
	private String type;
	private boolean active = false;

	/**
	 * 
	 * constructor of tool button
	 *
	 * @param toolType
	 */
	public ToolButton(String toolType){
		this.type = toolType;
		this.setText(toolType);
	}
	
	/**
	 * 
	 * return the name of the tool being used
	 *
	 * @return type
	 */
	public String getType(){
		return this.type;
	}
	
	/**
	 * 
	 * access the status of the tool button
	 *
	 * @return this.active
	 */
	public boolean isActive(){
		return this.active;
	}
	
	/**
	 * 
	 * set active status of tool button
	 *
	 * @param b
	 */
	public void setActive(boolean b){
		this.active = b;
	}
	
	public void actionPerformed(ActionEvent e){
		this.setActive(true);
	}

}
