import java.awt.Color;
import java.awt.geom.Ellipse2D;


/**
 * freehand paintbrush tool
 *
 * @author Joe Wanstrath.
 *         Created Mar 27, 2008.
 */
public class Paintbrush extends Ellipse2D.Double implements Tool{
	private Color color;
	private double xCorner,yCorner,size;
	/**
	 * 
	 * create a paintbrush tool
	 *
	 * @param x the point to be drawn at
	 * @param y the point to be drawn at
	 * @param size the size of the brush
	 * @param color the color of this tool
	 */
	public Paintbrush(int x,int y, int size, Color color){
		super(x,y,size,size);
		this.xCorner = x;
		this.yCorner = y;
		this.size = size;
		this.color = color;
	}

	public Color getColor() {
		return this.color;
	}

	public void setColor(Color color) {
		this.color = color;
		
	}
	
	@Override
	public String toString(){
		return new String(this.color + " " + this.xCorner + " " + this.yCorner + " " + this.size);
	}
}
