import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;

import javax.swing.*;

/**
 * Paint class. Initializes the program.
 *
 * @author Pete Brousalis.
 *         Created Apr 14, 2008.
 */
public class Paint extends JFrame
{
	private CanvasPanel canvasPanel;
	private ColorButtonPanel colorButtonPanel;
	private ToolButtonPanel toolButtonPanel;
	
	private Container mainContainer;
	
	/**
	 * Height of the paint window.
	 */
	public int WIN_HEIGHT=500;
	/**
	 * Width of the game window.
	 */
	public int WIN_WIDTH=700;
	
	private ArrayList<ToolButton> tools = new ArrayList<ToolButton>();

	/**
	 * Menu bar for File Menu.
	 */
	JMenuBar mainBar;
	/**
	 * File Menu JMenu.
	 */
	JMenu fileMenu;
	/**
	 * Creates a new file to draw on.
	 */
	JMenuItem newItem; 
	/**
	 * Clears the current file, empty whiteboard.
	 */
	JMenuItem clearItem;
	/**
	 * Exits the program.
	 */
	JMenuItem exitItem;
	
	/**
	 * Constructs the canvas, menubar, etc.
	 *
	 */
	public Paint()
	{
		super("PR Paint!");
	
		this.mainBar = new JMenuBar();
		setJMenuBar(this.mainBar);

		this.fileMenu = new JMenu("File");
			this.newItem	= new JMenuItem("New");
			this.clearItem = new JMenuItem("Clear"); 
			this.exitItem= new JMenuItem("Exit");
		
		this.newItem.addActionListener(new MenuButtonListener());
		this.clearItem.addActionListener(new MenuButtonListener());
		this.exitItem.addActionListener(new MenuButtonListener());
		
		this.fileMenu.add(this.newItem);
		this.fileMenu.add(this.clearItem);
		this.fileMenu.addSeparator();
		this.fileMenu.add(this.exitItem);
			
		this.mainBar.add(this.fileMenu);

		// end of setting up JMenuBar
		
		this.toolButtonPanel = new ToolButtonPanel(this);
		this.canvasPanel = new CanvasPanel();
		this.colorButtonPanel = new ColorButtonPanel(this.canvasPanel);
		
		this.mainContainer = getContentPane();
		this.mainContainer.add(this.toolButtonPanel,BorderLayout.NORTH);
		this.mainContainer.add(this.canvasPanel,BorderLayout.CENTER);
		this.mainContainer.add(this.colorButtonPanel,BorderLayout.WEST);
		
		this.canvasPanel.setBorder(BorderFactory.createMatteBorder(5,10,5,5,Color.gray));
		setSize(this.WIN_WIDTH,this.WIN_HEIGHT);
		this.setResizable(true);
		setVisible(true);		
		
		//this.canvasPanel.setComponentZOrder(canvasPanel,0);
	}

	/**
	 * Listens to the menu items, and when they are clicked do the required
	 * action.
	 *
	 * @author Pete Brousalis.
	 *         Created Apr 14, 2008.
	 */
	public class MenuButtonListener implements ActionListener
	{
		public void actionPerformed(ActionEvent event)
		{
			if(event.getSource() == Paint.this.newItem || event.getSource() == Paint.this.clearItem)
			{
				Paint.this.canvasPanel.clearCanvas();
				Paint.this.canvasPanel.setDrawMode(4);
				Paint.this.canvasPanel.setObjectColor(Color.BLACK);
				Paint.this.canvasPanel.setBackGroundColor(Color.WHITE);
			}
			if(event.getSource() == Paint.this.exitItem)
			{
				System.exit(0);
			}
		}
	}

	/**
	 * Starts the program.
	 *
	 * @param args
	 */
	public static void main(String args[])
	{
		Paint application = new Paint();
		application.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
	/**
	 * Adds the tools list with ToolButton
	 *
	 * @param obj
	 */
	public void addToolsList(ToolButton obj){
		this.tools.add(obj);
	}

	/**
	 * Changes the mode so CanvasPanel knows what tool to use.
	 *
	 * @param a
	 */
	public void changeMode(int a){
		Paint.this.canvasPanel.setDrawMode(a);
	}

}
