import javax.swing.JToolBar;
import javax.swing.SwingConstants;

/**
 * The toolbar that holds the various drawing buttons.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 4, 2008.
 */
public class ToolBar extends JToolBar {

	/**
	 * Constructs the bar that will hold the tool buttons.
	 * 
	 * @param drawArea
	 *            The area in which things will be drawn.
	 * 
	 */
	public ToolBar(DrawableArea drawArea) {
		super(SwingConstants.VERTICAL);
		this.setFloatable(false);
		addToolButtons(this, drawArea);
	}

	private void addToolButtons(ToolBar bar, DrawableArea drawArea) {
		// Images added to the buttons are from Microsoft Paint. We believe it
		// is fair use to use them in this educational project.
		String[] tools = { "Pencil", "Brush", "Eraser", "Line", "Rectangle",
				"Oval", "Polygon", "Spray Paint" };
		for (String tool : tools) {
			ToolButton button = new ToolButton(tool, drawArea);
			bar.add(button);
		}
	}
}
