import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;

/**
 * Draws a polygon depending on how the user clicks and drags lines around.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 11, 2008.
 */
public class PolygonTool extends Tool {

	private int x1, y1;

	private ArrayList<Integer> xPoints = new ArrayList<Integer>();

	private ArrayList<Integer> yPoints = new ArrayList<Integer>();

	private int numPoints = 0;

	private boolean doneDrawing = false;

	private ArrayList<Line2D.Double> lineList = new ArrayList<Line2D.Double>();

	private Color OutlineColor;

	private Color FillColor;

	/**
	 * Creates a polygon tool with access to the given DrawableArea.
	 * 
	 * @param drawArea
	 *            The DrawableArea the tool has access to.
	 */
	public PolygonTool(DrawableArea drawArea) {
		this.drawArea = drawArea;
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		if (e.getClickCount() >= 2) {
			this.doneDrawing = true;
			this.drawArea.disableLastTool();
			this.drawArea.addTool(new PolygonTool(this.drawArea));
			this.OutlineColor = this.drawArea.getOutlineColor();
			this.FillColor = this.drawArea.getFillColor();
			this.getParent().repaint();
		}
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		if (this.lineList.size() > 0) {
			this.lineList.remove(this.lineList.size() - 1);
		}
		Line2D.Double newLine = new Line2D.Double(this.x1, this.y1, e.getX(), e
				.getY());
		this.lineList.add(newLine);
		this.getParent().repaint();
	}

	@Override
	public void mousePressed(MouseEvent e) {
		if (this.lineList.size() == 0) {
			this.x1 = e.getX();
			this.y1 = e.getY();
		} else {
			this.x1 = (int) this.lineList.get(this.lineList.size() - 1).x2;
			this.y1 = (int) this.lineList.get(this.lineList.size() - 1).y2;
		}
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		if (this.lineList.size() > 0) {
			if (this.lineList.size() == 1) {
				this.xPoints.add(this.x1);
				this.yPoints.add(this.y1);
				this.numPoints += 1;
			}
			this.xPoints.add(e.getX());
			this.yPoints.add(e.getY());
			this.numPoints += 1;
			Line2D.Double newLine = new Line2D.Double(this.x1, this.y1, e
					.getX(), e.getY());
			this.lineList.add(newLine);
			this.xPoints.add(e.getX());
			this.yPoints.add(e.getY());
			this.numPoints += 1;
		}
		this.getParent().repaint();
	}

	@Override
	public void drawTool(Graphics g) {
		super.drawTool(g);
		Graphics2D g2 = (Graphics2D) g;
		if (this.doneDrawing) {
			int[] xPoints = new int[this.numPoints];
			int[] yPoints = new int[this.numPoints];
			for (int i = 0; i < this.numPoints; i++) {
				xPoints[i] = this.xPoints.get(i);
				yPoints[i] = this.yPoints.get(i);
			}
			if (this.FillColor != null) {
				g2.setColor(this.FillColor);
				g2.fill(new Polygon(xPoints, yPoints, this.numPoints));
			}
			g2.setColor(this.OutlineColor);
			g2.draw(new Polygon(xPoints, yPoints, this.numPoints));
		} else {
			for (int i = 0; i < this.lineList.size(); i++) {
				g2.setColor(this.drawArea.getOutlineColor());
				g2.draw(this.lineList.get(i));
			}
		}
	}
}
