import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;

/**
 * Draws freehand lines wherever the user clicks and drags the mouse.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 4, 2008.
 */
public class PencilTool extends Tool {

	private int lastX = 0;

	private int lastY = 0;

	private ArrayList<Line2D.Double> lineList = new ArrayList<Line2D.Double>();

	/** Color to draw with. */
	protected Color color;

	/**
	 * Creates a PencilTool and sets it's drawable area.
	 * 
	 * @param drawArea
	 *            The area in which the tool draws.
	 */
	public PencilTool(DrawableArea drawArea) {
		this.drawArea = drawArea;
	}

	private void record(int x, int y) {
		this.lastX = x;
		this.lastY = y;
	}

	@Override
	public void mousePressed(MouseEvent e) {
		record(e.getX(), e.getY());
		this.color = this.drawArea.getOutlineColor();
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
		this.lineList.add(new Line2D.Double(this.lastX, this.lastY, x, y));
		record(x, y);
		this.getParent().repaint();
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		this.repaint();
		this.drawArea.disableLastTool();
		this.drawArea.addTool(new PencilTool(this.drawArea));
	}

	@Override
	public void drawTool(Graphics g) {
		super.drawTool(g);
		Graphics2D g2 = (Graphics2D) g;
		g2.setColor(this.color);
		for (int i = 0; i < this.lineList.size(); i++) {
			g2.draw(this.lineList.get(i));
		}
	}
}
