import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;

/**
 * A tool that allows the user to click and drag to create lines on the screen.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 12, 2008.
 */
public class LineTool extends Tool {

	private Line2D.Double line;

	private Color color;

	private int x1, y1;

	/**
	 * Creates a line tool that has access to the given DrawableArea.
	 * 
	 * @param drawArea
	 *            The area the tool draws in.
	 */
	public LineTool(DrawableArea drawArea) {
		this.drawArea = drawArea;
		this.line = new Line2D.Double(0, 0, 0, 0);
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		this.line.x1 = this.x1;
		this.line.y1 = this.y1;
		this.line.x2 = e.getX();
		this.line.y2 = e.getY();
		this.getParent().repaint();
	}

	@Override
	public void mousePressed(MouseEvent e) {
		this.x1 = e.getX();
		this.y1 = e.getY();
		this.color = this.drawArea.getOutlineColor();
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		if (!(this.x1 == e.getX() && this.y1 == e.getY())) {
			this.line.x1 = this.x1;
			this.line.y1 = this.y1;
			this.line.x2 = e.getX();
			this.line.y2 = e.getY();
			this.getParent().repaint();
		}
		this.drawArea.disableLastTool();
		this.drawArea.addTool(new LineTool(this.drawArea));
	}

	@Override
	public void drawTool(Graphics g) {
		super.drawTool(g);
		Graphics2D g2 = (Graphics2D) g;
		g2.setColor(this.color);
		g2.draw(this.line);
	}
}
