import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;

/**
 * Draws a freehand brush stroke where the user clicks and drags.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 7, 2008.
 */
public class BrushTool extends PencilTool {

	/**
	 * Constructs a brush tool with the given area it will draw in.
	 * 
	 * @param drawArea
	 *            The area the tool will draw in.
	 */
	public BrushTool(DrawableArea drawArea) {
		super(drawArea);
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		this.drawArea.repaint();
		this.drawArea.disableLastTool();
		this.drawArea.addTool(new BrushTool(this.drawArea));
	}

	@Override
	public void drawTool(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		BasicStroke brush = new BasicStroke(8.0F);
		g2.setStroke(brush);
		super.drawTool(g);
		g2.setStroke(new BasicStroke());
	}

}
