import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

/**
 * 
 */

/**
 * @author Jon Klein, CM2296
 *
 */
public class PaintButton extends JButton implements ActionListener
{

	/**
	 * The number of the button in the panel.
	 */
	public int buttonid;
	private String buttonname;
	private Color color;
	private ButtonPanel panel;

	/**
	 * @param string the message on the button
	 * @param number the number of the button, may not be used
	 * 
	 */
	public PaintButton(String string, int number)
	{
		super(string);
		this.buttonname = string;
		this.buttonid = number;
	}
	
	
	@Override
	public void actionPerformed(ActionEvent arg0)
	{
		// diagnostic output, should change
		this.panel.getSelected().setBorderPainted(true);
		this.panel.setSelected(this);
		this.setBorderPainted(false);
		
	}
	
	/**
	 * @param color 
	 * The color to set.
	 */
	public void setColor(Color color)
	{
		this.color = color;
		this.setBackground(this.color);
	}
	
	/**
	 * @return the color of the button.
	 */
	public Color getColor()
	{
		return this.color;
	}

	/**
	 * @return A string containing the name of a button.
	 */
	public String getButtonName()
	{
		return this.buttonname;
	}

	/**
	 * Sets the button panel of the button.
	 * @param panel The panel the button belongs to, required for button/panel communications.
	 */
	public void setPanel(ButtonPanel panel)
	{
		this.panel = panel;
	}



}
