import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JFrame;
import javax.swing.JPanel;


/**
 * @author Jon Klein, CM2296
 *
 */
public class DrawingArea extends JFrame implements KeyListener
{

	
	/**
	 * @param args
	 */
	
	/** mmmkay, width of window? **/
	public static final int FRAME_WIDTH = 600;
	/** mmmkay, height of window? **/
	public static final int FRAME_HEIGHT = 600;
	
	// determines the number of buttons in the panels
	private static final int BOTTOM_COLS = 7;
	private static final int BOTTOM_ROWS = 2;
	private static final int SIDE_ROWS = 4;
	private static final int SIDE_COLS = 2;
	
	// these likely don't *need* to all be fields..
	private BottomPanel bpanel;
	private SidePanel spanel;
	private DrawingPanel dpanel;
	private TopPanel tpanel;
	private JPanel ppanel;
	
	
	
	/**
	 *  Creates a drawing area.
	 *  Creates all necessary panels in the right places, and facilitates panel communication by giving panels each others phone numbers.
	 * 
	 */
	public DrawingArea()
	{
		// set up panels, fun fun fun
		this.spanel = new SidePanel(SIDE_ROWS, SIDE_COLS);
		this.dpanel = new DrawingPanel();
		this.bpanel = new BottomPanel(BOTTOM_ROWS, BOTTOM_COLS, this.dpanel);
		this.tpanel = new TopPanel();
		this.ppanel = new JPanel(new BorderLayout());
		tpanel.addDrawPanel(dpanel);
		tpanel.addDrawArea(this);
		ppanel.add(tpanel, BorderLayout.NORTH);
		ppanel.add(bpanel, BorderLayout.SOUTH);
		ppanel.add(spanel, BorderLayout.WEST);
		ppanel.add(dpanel, BorderLayout.CENTER);
		dpanel.setPanels(spanel, bpanel);
		this.add(ppanel);
		dpanel.addKeyListener(this);
		
		
	}
	
	/**
	 * Main, creates paint!! Start here.
	 * @param args
	 */
	public static void main(String[] args)
	{
		JFrame frame = new DrawingArea();
		frame.setSize(FRAME_WIDTH, FRAME_HEIGHT);
		frame.setTitle("JPaint, Group 112");
		frame.setResizable(false);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setVisible(true);
	}
	
	/**
	 *  Exits paint, hard exit, files will corrupt.
	 */
	public void exit()
	{
		dispose();
	}

	@Override
	public void keyPressed(KeyEvent arg0)
	{
		
		switch (arg0.getKeyCode())
		{
			// Add more keycodes here!
		
			case KeyEvent.VK_U:
				dpanel.undo();
				break;
			case KeyEvent.VK_SHIFT:
				dpanel.setShift(true);
				break;
		}
		
		
	}

	@Override
	public void keyReleased(KeyEvent arg0)
	{
		switch (arg0.getKeyCode())
		{
			case KeyEvent.VK_SHIFT:
				dpanel.setShift(false);
				break;
		}
		
	}

	@Override
	public void keyTyped(KeyEvent arg0)
	{
		// add more stuff here is wanted
	}



}
