import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * @author Jon Klein, CM2296
 * Class that contains the bottom panel of the paint program.
 */
public class BottomPanel extends ButtonPanel implements ChangeListener
{
	private Color[] easel = new Color[] 
	       {Color.black, Color.lightGray, Color.blue, Color.magenta, Color.cyan, Color.orange, 
			Color.darkGray, Color.pink, Color.gray, Color.red, Color.green, Color.white, Color.yellow};
	
	private JTextField mouselocation = new JTextField("mouselocation");
	protected Color fillcolor = Color.white;
	private SpinnerNumberModel brushcontroller = new SpinnerNumberModel(1,1,10, 1);
	private JSpinner brushspinner = new JSpinner(brushcontroller);
	private DrawingPanel dpanel;
	/**
	 * Constructs the bottom panel of the paint GUI.
	 * @param rows The number of rows desired for the bottom panel
	 * @param cols The number of colums desired for the bottom panel
	 * @param dpanel Drawing panel, so this panel may communicate brush size information.
	 */
	public BottomPanel(int rows, int cols, DrawingPanel dpanel)
	{
		super( new GridLayout(rows, cols + 1), rows * cols);
		this.dpanel = dpanel;
		for (int i = 0; i < easel.length; i++)
		{
			this.Buttons.get(i).setColor(easel[i]);
		}
		
		this.Buttons.get(easel.length).setText("fill color");
		Buttons.get(easel.length).setColor(fillcolor);
		Buttons.get(easel.length).setToolTipText("Press me to set the currently selected color as the fill color.");
		this.Buttons.get(easel.length).addActionListener(new ActionListener() 
    	{
			public void actionPerformed(ActionEvent arg0) 
            { 
                fillcolor = getSelected().getColor();
                Buttons.get(easel.length).setColor(fillcolor);
                
            }
    	});
		
		this.add(this.mouselocation);
		this.brushspinner.addChangeListener(this);
		this.add(this.brushspinner);
		
		
	}
	
	/**
	 * Set the display of the current mouse location in the bottom panel
	 * @param x x location
	 * @param y y location
	 */
	public void setMouseLocation(int x, int y)
	{
		this.mouselocation.setText(x + "," + y);
		if (x < 0 || y < 0)
		this.mouselocation.setText("");
	}
	

	/**
	 * @return The currently selected fill color on the panel.
	 */
	public Color getFillColor()
	{
		return this.fillcolor;
	}

	@Override
	public void stateChanged(ChangeEvent arg0)
	{
		this.dpanel.setBrushWidth(this.brushcontroller.getNumber().intValue());
		
	}

}
