import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;


/**
 * draws a rectangle that is not filled
 *
 * @author Matthew Drosos and Colin DeClue.
 *         Created Apr 14, 2008.
 */
public class Rectangle implements Tool {
	private boolean started;
	private ArrayList<Shape> shapes;
	private Point2D.Double start;
	private ArrayList<Boolean> fill;
	private ArrayList<Color> color;
	private ColorPanel colorPanel;
	/**
	 * determines if the rectangle should be filled or not
	 */
	protected Boolean toFill;
	private ArrayList<WorldPanel> panels;

	
	/**
	 * creates an unfilled rectangle of the given color
	 *
	 * @param shapes - an ArrayList of shapes drawn to the panel
	 * @param fill - an ArrayList of booleans that determine if the shape should be filled
	 * @param color - an ArrayList of colors of the corresponding shapes
	 * @param colorPanel - allows access to color panel functions
	 * @param panels - an ArrayList of panels in the WorldPanel
	 */
	public Rectangle(ArrayList<Shape> shapes, ArrayList<Boolean> fill, ArrayList<Color> color, ColorPanel colorPanel, ArrayList<WorldPanel> panels)
	{
		this.shapes=shapes;
		this.fill=fill;
		this.toFill = false;
		this.colorPanel = colorPanel;
		this.panels = panels;
		this.color=color;
		this.started=false;
	}
	public void clicked(MouseEvent event) {
		// TODO Auto-generated method stub

	}

	public void dragged(MouseEvent event) {
		double xMax = (this.start.getX() > event.getX()? this.start.getX() : event.getX());
		double yMax = (this.start.getY() > event.getY()? this.start.getY() : event.getY());
		double xMin = (this.start.getX() < event.getX()? this.start.getX() : event.getX());
		double yMin = (this.start.getY() < event.getY()? this.start.getY() : event.getY());
		if (this.started)
		{
			this.shapes.remove(this.shapes.size()-1);
			this.fill.remove(this.fill.size()-1);
			this.color.remove(this.color.size()-1);
			this.panels.get(0).resetShapesIndex();
		}
		this.shapes.add(new Rectangle2D.Double(xMin,yMin,xMax-xMin,yMax-yMin));
		this.fill.add(this.toFill);
		this.color.add(this.colorPanel.getCurrentColor());
		this.started = true;

	}

	public void pressed(MouseEvent event) {
		this.start = new Point2D.Double(event.getX(),event.getY());

	}

	public void release(MouseEvent event) {
		this.started=false;

	}
	


}
