import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;


/**
 * creates an eraser tool and its implementation
 *
 * @author Matt Drosos and Colin DeClue.
 *         Created Apr 14, 2008.
 */
public class Eraser extends Pencil {
	private Point2D.Double previousPoint;
	private boolean previousBool;
	
	/**
	 * creates an eraser
	 *
	 * @param shapes - an ArrayList of shapes drawn to the panel
	 * @param fill - an ArrayList of booleans that determine if the shape should be filled
	 * @param color - an ArrayList of colors of the corresponding shapes
	 * @param colorPanel - allows access to color panel functions
	 * @param panels - an ArrayList of panels in the WorldPanel
	 */
	public Eraser(ArrayList<Shape> shapes, ArrayList<Boolean> fill, ArrayList<Color> color, ColorPanel colorPanel) {
		super(shapes, fill, color, colorPanel);
		this.previousBool=false;
	}
	
	@Override
	public void clicked(MouseEvent event)
	{
		this.shapes.add(new Rectangle2D.Double(event.getX(), event.getY(), 10,10));
		this.fill.add(true);
		this.color.add(Color.white);
	}
	

	@Override
	public void dragged(MouseEvent event)
	{
		//this.shapes.add(new Ellipse2D.Double(event.getX(), event.getY(), 10,10));
		if (this.previousBool)
		{
			for(int i = 0; i <= 10; i++)
			{
				this.shapes.add(new Line2D.Double(event.getX() + i - 5, event.getY() + 5 - 5, this.previousPoint.getX() + i, this.previousPoint.getY() + 5));
				this.fill.add(false);
				this.color.add(Color.white);
				this.shapes.add(new Line2D.Double(event.getX() + 5 - 5, event.getY() + i - 5, this.previousPoint.getX() + 5, this.previousPoint.getY() + i));
				this.fill.add(false);
				this.color.add(Color.white);
			}
			
		}
		this.previousPoint = new Point2D.Double(event.getPoint().getX() - 5,event.getPoint().getY() - 5);
		this.previousBool=true;
	}
	
	@Override
	public void release(MouseEvent event) {
		this.previousBool = false;
		this.shapes.add(new Rectangle2D.Double(event.getX() - 5, event.getY() - 5, 10,10));
		this.fill.add(true);
		this.color.add(Color.white);
	}
	
	@Override
	public void pressed(MouseEvent event) {
		this.shapes.add(new Rectangle2D.Double(event.getX() - 5, event.getY() - 5, 10,10));
		this.fill.add(true);
		this.color.add(Color.white);
	}
	
}
