import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;


/**
 * creates a calligraphy pen tool
 *
 * @author Matt Drosos and Colin DeClue.
 *         Created Apr 14, 2008.
 */
public class CalligraphyPen extends Pencil {
	private Point2D.Double previousPoint;
	private boolean previousBool;
	/**
	 * creates a calligraphy pen
	 *
	 * @param shapes - an ArrayList of shapes drawn to the panel
	 * @param fill - an ArrayList of booleans that determine if the shape should be filled
	 * @param color - an ArrayList of colors of the corresponding shapes
	 * @param colorPanel - allows access to color panel functions
	 * @param panels - an ArrayList of panels in the WorldPanel
	 */
	public CalligraphyPen(ArrayList<Shape> shapes, ArrayList<Boolean> fill, ArrayList<Color> color, ColorPanel colorPanel) {
		super(shapes, fill, color, colorPanel);
		this.previousBool=false;
	}
	
	@Override
	public void dragged(MouseEvent event)
	{
		if (this.previousBool)
		{
			for(int i = -10; i < 10; i++)
			{
				this.shapes.add(new Line2D.Double(event.getX()+i,event.getY()+i,this.previousPoint.getX()+i,this.previousPoint.getY()+i));
				this.fill.add(this.toFill);
				this.color.add(this.colorPanel.getCurrentColor());
			}
		}
		this.previousPoint = new Point2D.Double(event.getPoint().getX(),event.getPoint().getY());
		this.previousBool=true;
	}
	
	@Override
	public void release(MouseEvent event) {
		this.previousBool = false;
	}
	

}
