import java.awt.geom.Rectangle2D;


/**
 * Rectangle Tool
 *
 * @author Richard Stover.
 *         Created Apr 9, 2008.
 */
public class Rectangle implements Tools{
	
	private int x;
	private int y;
	
	/**
	 * creates the Rectangle
	 *
	 * @param x
	 * @param y
	 */
	public Rectangle(int x, int y) {
		this.x = x;
		this.y = y;
	}
	
	/**
	 * draws the rectangle
	 *
	 * @param i
	 * @param j
	 * @param g
	 * @return Rectangle made from current mouse position
	 */
	public Rectangle2D draw(int i, int j) {
		if(i>this.x && j>this.y){
			return new Rectangle2D.Double(this.x,this.y,i-this.x,j-this.y);
		}
		else if(i<this.x && j>this.y){
			return new Rectangle2D.Double(this.x-(this.x-i),this.y,this.x-i,j-this.y);
		}
		else if(i>this.x && j<this.y){
			return new Rectangle2D.Double(i-(i-this.x),j,i-this.x,this.y-j);
		}
		else if(i<this.x && j<this.y){
			return new Rectangle2D.Double(i,j,this.x-i,this.y-j);
		}
		else{
			return new Rectangle2D.Double(i,j,0,0);	
		}
	}

	/**
	 * restrains the rectangle to a square
	 *
	 * @param i
	 * @param j
	 * @return Square made from current mouse position
	 */
	public Object drawSquare(int i, int j) {
		if(i>this.x && j>this.y){
			if(i-this.x < j-this.y){
				return new Rectangle2D.Double(this.x,this.y,i-this.x,i-this.x);
			}else{
				return new Rectangle2D.Double(this.x,this.y,j-this.y,j-this.y);				
			}
		}
		else if(i<this.x && j>this.y){
			if(this.x-i < j-this.y) {
				return new Rectangle2D.Double(this.x-(this.x-i),this.y,this.x-i,this.x-i);
			}else{
				return new Rectangle2D.Double(this.x-(j-this.y),this.y,j-this.y,j-this.y);
			}
		}
		else if(i>this.x && j<this.y){
			if(i-this.x < this.y-j){
				return new Rectangle2D.Double(this.x,this.y-(i-this.x),i-this.x,i-this.x);
			}else{
				return new Rectangle2D.Double(this.x,j,this.y-j,this.y-j);
			}
		}
		else if(i<this.x && j<this.y){
			if(this.x-i < this.y-j){
				return new Rectangle2D.Double(i,j+(this.y-j)-(this.x-i),this.x-i,this.x-i);
			}else{
				return new Rectangle2D.Double(i+(this.x-i)-(this.y-j),j,this.y-j,this.y-j);
			}
		}
		else{
			return new Rectangle2D.Double(i,j,0,0);	
		}
	}

}
