import java.awt.geom.Ellipse2D;


/**
 * Oval Tool
 *
 * @author Richard Stover.
 *         Created Apr 9, 2008.
 */
public class Oval implements Tools{
	
	private int x;
	private int y;

	/**
	 * creates the oval
	 *
	 * @param x
	 * @param y
	 */
	public Oval(int x, int y) {
		this.x = x;
		this.y = y;
	}
	
	/**
	 * draws the oval
	 *
	 * @param i
	 * @param j
	 * @return Oval made from current mouse position
	 */
	public Ellipse2D draw(int i, int j) {
		if(i>this.x && j>this.y){
			return new Ellipse2D.Double(this.x,this.y,i-this.x,j-this.y);
		}
		else if(i<this.x && j>this.y){
			return new Ellipse2D.Double(this.x-(this.x-i),this.y,this.x-i,j-this.y);
		}
		else if(i>this.x && j<this.y){
			return new Ellipse2D.Double(i-(i-this.x),j,i-this.x,this.y-j);
		}
		else if(i<this.x && j<this.y){
			return new Ellipse2D.Double(i,j,this.x-i,this.y-j);
		}
		else{
			return new Ellipse2D.Double(i,j,0,0);
		}
	}

	/**
	 * restrains an oval to a circle
	 *
	 * @param i
	 * @param j
	 * @return Circle made from current mouse location
	 */
	public Object drawCircle(int i, int j) {
		if(i>this.x && j>this.y){
			if(i-this.x < j-this.y){
				return new Ellipse2D.Double(this.x,this.y,i-this.x,i-this.x);
			}else{
				return new Ellipse2D.Double(this.x,this.y,j-this.y,j-this.y);				
			}
		}
		else if(i<this.x && j>this.y){
			if(this.x-i < j-this.y) {
				return new Ellipse2D.Double(this.x-(this.x-i),this.y,this.x-i,this.x-i);
			}else{
				return new Ellipse2D.Double(this.x-(j-this.y),this.y,j-this.y,j-this.y);
			}
		}
		else if(i>this.x && j<this.y){
			if(i-this.x < this.y-j){
				return new Ellipse2D.Double(this.x,this.y-(i-this.x),i-this.x,i-this.x);
			}else{
				return new Ellipse2D.Double(this.x,j,this.y-j,this.y-j);
			}
		}
		else if(i<this.x && j<this.y){
			if(this.x-i < this.y-j){
				return new Ellipse2D.Double(i,j+(this.y-j)-(this.x-i),this.x-i,this.x-i);
			}else{
				return new Ellipse2D.Double(i+(this.x-i)-(this.y-j),j,this.y-j,this.y-j);
			}
		}
		else{
			return new Ellipse2D.Double(i,j,0,0);	
		}
	}
}
