import java.awt.geom.Line2D;

/**
 * Line Tool
 * 
 * @author Richard Stover. Created Apr 11, 2008.
 */
public class Line implements Tools {

	private int x;

	private int y;

	private Line2D line;

	/**
	 * creates the Line
	 * 
	 * @param x
	 * @param y
	 */
	public Line(int x, int y) {

		this.x = x;
		this.y = y;
		this.line = new Line2D.Double(x, y, x, y);
	}

	/**
	 * draws the Line
	 * 
	 * @param i
	 * @param j
	 * @return Line made from current mouse positon
	 */
	public Line2D draw(int i, int j) {

		this.line.setLine(this.x, this.y, i, j);
		return this.line;
	}

	/**
	 * connects all the points of the Line
	 * 
	 * @param i
	 * @param j
	 * @return Horizontal or vertical line made from current mouse position
	 */
	public Object drawStraight(int i, int j) {

		if (Math.abs(this.x - i) < Math.abs(this.y - j)) {
			if (this.y < j) {
				this.line.setLine(this.x, this.y, this.x, j);
			} else {
				this.line.setLine(this.x, this.y, this.x, j);
			}
		} else {
			if (this.x < i) {
				this.line.setLine(this.x, this.y, i, this.y);
			} else {
				this.line.setLine(this.x, this.y, i, this.y);
			}
		}
		return this.line;
	}

}
